/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.hub;

import io.netty.buffer.ByteBuf;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.net.websub.BallerinaWebSubException;
import org.ballerinalang.net.websub.broker.BallerinaBroker;
import org.ballerinalang.net.websub.broker.BallerinaBrokerByteBuf;
import org.ballerinalang.net.websub.hub.HubSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hub {
    private static final Logger logger = LoggerFactory.getLogger(Hub.class);
    private static Hub instance = new Hub();
    private BallerinaBroker brokerInstance = null;
    private ObjectValue hubObject = null;
    private String hubUrl;
    private boolean hubTopicRegistrationRequired;
    private boolean hubPersistenceEnabled;
    private volatile boolean started = false;
    private List<String> topics = new ArrayList<String>();
    private List<HubSubscriber> subscribers = new ArrayList<HubSubscriber>();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private static final String BASE_PATH = "/websub";
    private static final String HUB_PATH = "/hub";
    private static final String HUB_SERVICE = "hub_service";

    public static Hub getInstance() {
        return instance;
    }

    private Hub() {
    }

    public String getHubUrl() {
        return this.hubUrl;
    }

    public ObjectValue getHubObject() {
        return this.hubObject;
    }

    public void registerTopic(Strand strand, String topic, boolean loadingOnStartUp) throws BallerinaWebSubException {
        if (this.isTopicRegistered(topic)) {
            throw new BallerinaWebSubException("Topic registration not allowed at the Hub: topic already exists");
        }
        if (topic == null || topic.isEmpty()) {
            throw new BallerinaWebSubException("Topic unavailable/invalid for registration at Hub");
        }
        this.topics.add(topic);
        if (this.hubPersistenceEnabled && !loadingOnStartUp) {
            Object[] args = new Object[]{"register", topic};
            Executor.executeFunction((Scheduler)strand.scheduler, (ClassLoader)this.classLoader, (String)"ballerina", (String)"websub", (String)HUB_SERVICE, (String)"persistTopicRegistrationChange", (Object[])args);
        }
    }

    public void unregisterTopic(Strand strand, String topic) throws BallerinaWebSubException {
        if (topic == null || !this.isTopicRegistered(topic)) {
            throw new BallerinaWebSubException("Topic unavailable/invalid for unregistration at Hub");
        }
        this.topics.remove(topic);
        if (this.hubPersistenceEnabled) {
            Object[] args = new Object[]{"unregister", topic};
            Executor.executeFunction((Scheduler)strand.scheduler, (ClassLoader)this.classLoader, (String)"ballerina", (String)"websub", (String)HUB_SERVICE, (String)"persistTopicRegistrationChange", (Object[])args);
        }
    }

    public boolean isTopicRegistered(String topic) {
        return this.topics.contains(topic);
    }

    public void registerSubscription(Strand strand, String topic, String callback, MapValue<String, Object> subscriptionDetails) {
        if (!this.started) {
            logger.error("Hub Service not started: subscription failed");
        } else if (!this.topics.contains(topic) && this.hubTopicRegistrationRequired) {
            logger.warn("Subscription request ignored for unregistered topic[" + topic + "]");
        } else {
            if (this.getSubscribers().contains((Object)new HubSubscriber(strand, "", topic, callback, null))) {
                this.unregisterSubscription(strand, topic, callback);
            }
            String queue = UUID.randomUUID().toString();
            HubSubscriber subscriberToAdd = new HubSubscriber(strand, queue, topic, callback, subscriptionDetails);
            this.brokerInstance.addSubscription(topic, subscriberToAdd);
            this.getSubscribers().add(subscriberToAdd);
        }
    }

    public void unregisterSubscription(Strand strand, String topic, String callback) {
        if (!this.started) {
            logger.error("Hub Service not started: unsubscription failed.");
            return;
        }
        HubSubscriber subscriberToUnregister = new HubSubscriber(strand, "", topic, callback, null);
        if (!this.getSubscribers().contains((Object)subscriberToUnregister)) {
            if (callback.endsWith("/")) {
                this.unregisterSubscription(strand, topic, callback.substring(0, callback.length() - 1));
            }
            return;
        }
        for (HubSubscriber subscriber : this.getSubscribers()) {
            if (!subscriber.equals((Object)subscriberToUnregister)) continue;
            subscriberToUnregister = subscriber;
            break;
        }
        this.brokerInstance.removeSubscription(subscriberToUnregister);
        this.getSubscribers().remove((Object)subscriberToUnregister);
    }

    public void publish(String topic, MapValue<String, Object> content) throws BallerinaWebSubException {
        if (!this.started) {
            throw new BallerinaWebSubException("Hub Service not started: publish failed");
        }
        if (!this.topics.contains(topic) && this.hubTopicRegistrationRequired) {
            throw new BallerinaWebSubException("Publish call ignored for unregistered topic[" + topic + "]");
        }
        this.brokerInstance.publish(topic, (ByteBuf)new BallerinaBrokerByteBuf(content));
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUpHubService(Strand strand, boolean topicRegistrationRequired, String publicUrl, ObjectValue hubListener) {
        Hub hub = this;
        synchronized (hub) {
            if (!this.isStarted()) {
                try {
                    this.brokerInstance = BallerinaBroker.getBrokerInstance();
                }
                catch (Exception e) {
                    throw new BallerinaException("Error starting up internal broker for WebSub Hub");
                }
            } else {
                throw new BallerinaWebSubException("Hub Service already started up");
            }
            this.hubTopicRegistrationRequired = topicRegistrationRequired;
            String hubUrl = this.populateHubUrl(publicUrl, hubListener);
            Object returnValue = Executor.executeFunction((Scheduler)strand.scheduler, (ClassLoader)this.classLoader, (String)"ballerina", (String)"websub", (String)"hub_configuration", (String)"isHubPersistenceEnabled", (Object[])new Object[0]);
            this.hubPersistenceEnabled = Boolean.parseBoolean(returnValue.toString());
            PrintStream console = System.err;
            console.println("[ballerina/websub] Default Ballerina WebSub Hub started up at " + hubUrl);
            this.started = true;
            Executor.executeFunction((Scheduler)strand.scheduler, (ClassLoader)this.classLoader, (String)"ballerina", (String)"websub", (String)HUB_SERVICE, (String)"setupOnStartup", (Object[])new Object[0]);
            this.setHubUrl(hubUrl);
            this.setHubObject(BallerinaValues.createObjectValue((String)"ballerina/websub", (String)"WebSubHub", (Object[])new Object[]{hubUrl, hubListener}));
        }
    }

    private String populateHubUrl(String hubUrl, ObjectValue hubListener) {
        if (hubUrl.isEmpty()) {
            String hubPort = String.valueOf(hubListener.get("port"));
            Object secureSocket = ((MapValue)hubListener.get("config")).get((Object)"secureSocket");
            hubUrl = secureSocket != null ? "https://localhost:" + hubPort + BASE_PATH + HUB_PATH : "http://localhost:" + hubPort + BASE_PATH + HUB_PATH;
        }
        return hubUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHubService() {
        Hub hub = this;
        synchronized (hub) {
            if (this.isStarted()) {
                this.started = false;
                this.setHubObject(null);
                this.setHubUrl(null);
                this.hubTopicRegistrationRequired = false;
                this.hubPersistenceEnabled = false;
                this.topics = new ArrayList<String>();
                for (HubSubscriber subscriber : this.getSubscribers()) {
                    this.brokerInstance.removeSubscription(subscriber);
                }
            } else {
                throw new BallerinaWebSubException("Hub Service already stopped");
            }
            this.subscribers = new ArrayList<HubSubscriber>();
            this.brokerInstance = null;
        }
    }

    private void setHubUrl(String hubUrl) {
        this.hubUrl = hubUrl;
    }

    private void setHubObject(ObjectValue hubObject) {
        this.hubObject = hubObject;
    }

    public String[] getTopics() {
        return this.topics.toArray(new String[0]);
    }

    public List<HubSubscriber> getSubscribers() {
        return this.subscribers;
    }
}

