/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.hub;

import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.Consumer;
import io.ballerina.messaging.broker.core.ContentChunk;
import io.ballerina.messaging.broker.core.Message;
import java.util.Objects;
import java.util.Properties;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.net.websub.broker.BallerinaBrokerByteBuf;

public class HubSubscriber
extends Consumer {
    private final String queue;
    private final String topic;
    private final String callback;
    private final MapValue<String, Object> subscriptionDetails;
    private final Scheduler scheduler;

    HubSubscriber(Strand strand, String queue, String topic, String callback, MapValue<String, Object> subscriptionDetails) {
        this.scheduler = strand.scheduler;
        this.queue = queue;
        this.topic = topic;
        this.callback = callback;
        this.subscriptionDetails = subscriptionDetails;
    }

    protected void send(Message message) throws BrokerException {
        MapValue content = (MapValue)((BallerinaBrokerByteBuf)((ContentChunk)message.getContentChunks().get(0)).getByteBuf().unwrap()).getValue();
        Object[] args = new Object[]{this.getCallback(), this.getSubscriptionDetails(), content};
        try {
            Executor.executeFunction((Scheduler)this.scheduler, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ballerina", (String)"websub", (String)"hub_service", (String)"distributeContent", (Object[])args);
        }
        catch (BallerinaException e) {
            throw new BallerinaException("send failed: " + e.getMessage());
        }
    }

    public String getQueueName() {
        return this.queue;
    }

    protected void close() throws BrokerException {
    }

    public boolean isExclusive() {
        return false;
    }

    public boolean isReady() {
        return true;
    }

    public boolean equals(Object subscriberObject) {
        if (subscriberObject instanceof HubSubscriber) {
            HubSubscriber subscriber = (HubSubscriber)((Object)subscriberObject);
            return subscriber.getTopic().equals(this.getTopic()) && subscriber.getCallback().equals(this.getCallback());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getTopic(), this.getCallback());
    }

    public Properties getTransportProperties() {
        return new Properties();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getCallback() {
        return this.callback;
    }

    public MapValue<String, Object> getSubscriptionDetails() {
        return this.subscriptionDetails;
    }
}

