/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.nativeimpl;

import java.util.List;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.websub.hub.Hub;
import org.ballerinalang.net.websub.hub.HubSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="websub", functionName="getSubscribers", args={@Argument(name="topic", type=TypeKind.STRING)}, receiver=@Receiver(type=TypeKind.OBJECT, structType="WebSubHub", structPackage="ballerina/websub"), returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.RECORD, structType="SubscriberDetails", structPackage="ballerina/websub")}, isPublic=true)
public class GetSubscribers {
    private static final Logger log = LoggerFactory.getLogger(GetSubscribers.class);

    public static ArrayValue getSubscribers(Strand strand, ObjectValue webSubHub, String topic) {
        ArrayValue subscriberDetailArray = null;
        try {
            List<HubSubscriber> subscribers = Hub.getInstance().getSubscribers();
            MapValue subscriberDetailsRecordValue = BallerinaValues.createRecordValue((String)"ballerina/websub", (String)"SubscriberDetails");
            subscriberDetailArray = new ArrayValue((BType)new BArrayType(subscriberDetailsRecordValue.getType()));
            for (HubSubscriber subscriber : subscribers) {
                if (!topic.equals(subscriber.getTopic())) continue;
                MapValue subscriberDetail = BallerinaValues.createRecord((MapValue)subscriberDetailsRecordValue, (Object[])new Object[]{subscriber.getCallback(), subscriber.getSubscriptionDetails().get((Object)"leaseSeconds"), subscriber.getSubscriptionDetails().get((Object)"createdAt")});
                subscriberDetailArray.append((Object)subscriberDetail);
            }
        }
        catch (Exception ex) {
            log.error("Error occurred while getting available subscribers.", (Throwable)ex);
        }
        return subscriberDetailArray;
    }
}

