/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.nativeimpl;

import java.util.HashMap;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.net.websub.WebSubServicesRegistry;

@BallerinaFunction(orgName="ballerina", packageName="websub", functionName="initWebSubSubscriberServiceEndpoint", receiver=@Receiver(type=TypeKind.OBJECT, structType="Listener", structPackage="ballerina/websub"))
public class InitWebSubSubscriberServiceEndpoint {
    public static void initWebSubSubscriberServiceEndpoint(Strand strand, ObjectValue subscriberServiceEndpoint) {
        WebSubServicesRegistry webSubServicesRegistry;
        ObjectValue serviceEndpoint = (ObjectValue)subscriberServiceEndpoint.get("serviceEndpoint");
        MapValue config = (MapValue)subscriberServiceEndpoint.get("config");
        if (config == null || config.get((Object)"extensionConfig") == null) {
            webSubServicesRegistry = new WebSubServicesRegistry(new WebSocketServicesRegistry());
        } else {
            MapValue extensionConfig = (MapValue)config.get((Object)"extensionConfig");
            String topicIdentifier = extensionConfig.getStringValue("topicIdentifier");
            String topicHeader = null;
            MapValue headerResourceMap = null;
            MapValue payloadKeyResourceMap = null;
            MapValue headerAndPayloadKeyResourceMap = null;
            if (("TOPIC_ID_HEADER".equals(topicIdentifier) || "TOPIC_ID_HEADER_AND_PAYLOAD".equals(topicIdentifier)) && (topicHeader = extensionConfig.getStringValue("topicHeader")) == null) {
                throw new BallerinaConnectorException("Topic Header not specified to dispatch by " + topicIdentifier);
            }
            if ("TOPIC_ID_HEADER".equals(topicIdentifier)) {
                headerResourceMap = (MapValue)extensionConfig.get((Object)"headerResourceMap");
                if (headerResourceMap == null) {
                    throw new BallerinaConnectorException("Resource map not specified to dispatch by header");
                }
            } else if ("TOPIC_ID_HEADER_AND_PAYLOAD".equals(topicIdentifier)) {
                headerAndPayloadKeyResourceMap = (MapValue)extensionConfig.get((Object)"headerAndPayloadKeyResourceMap");
                if (headerAndPayloadKeyResourceMap == null) {
                    throw new BallerinaConnectorException("Resource map not specified to dispatch by header and payload");
                }
                headerResourceMap = (MapValue)extensionConfig.get((Object)"headerResourceMap");
                payloadKeyResourceMap = (MapValue)extensionConfig.get((Object)"payloadKeyResourceMap");
            } else {
                payloadKeyResourceMap = (MapValue)extensionConfig.get((Object)"payloadKeyResourceMap");
                if (payloadKeyResourceMap == null) {
                    throw new BallerinaConnectorException("Resource map not specified to dispatch by payload");
                }
            }
            HashMap<String, BRecordType> resourceDetails = InitWebSubSubscriberServiceEndpoint.buildResourceDetailsMap(topicIdentifier, (MapValue<String, Object>)headerResourceMap, (MapValue<String, MapValue<String, Object>>)payloadKeyResourceMap, (MapValue<String, MapValue<String, MapValue<String, Object>>>)headerAndPayloadKeyResourceMap);
            webSubServicesRegistry = new WebSubServicesRegistry(new WebSocketServicesRegistry(), topicIdentifier, topicHeader, (MapValue<String, Object>)headerResourceMap, (MapValue<String, MapValue<String, Object>>)payloadKeyResourceMap, (MapValue<String, MapValue<String, MapValue<String, Object>>>)headerAndPayloadKeyResourceMap, resourceDetails);
        }
        serviceEndpoint.addNativeData("WEBSUB_SERVICE_REGISTRY", (Object)webSubServicesRegistry);
    }

    private static HashMap<String, BRecordType> buildResourceDetailsMap(String topicIdentifier, MapValue<String, Object> headerResourceMap, MapValue<String, MapValue<String, Object>> payloadKeyResourceMap, MapValue<String, MapValue<String, MapValue<String, Object>>> headerAndPayloadKeyResourceMap) {
        HashMap<String, BRecordType> resourceDetails = new HashMap<String, BRecordType>();
        if (topicIdentifier != null) {
            switch (topicIdentifier) {
                case "TOPIC_ID_HEADER": {
                    InitWebSubSubscriberServiceEndpoint.populateResourceDetailsByHeader(headerResourceMap, resourceDetails);
                    break;
                }
                case "TOPIC_ID_PAYLOAD_KEY": {
                    InitWebSubSubscriberServiceEndpoint.populateResourceDetailsByPayload(payloadKeyResourceMap, resourceDetails);
                    break;
                }
                default: {
                    InitWebSubSubscriberServiceEndpoint.populateResourceDetailsByHeaderAndPayload(headerAndPayloadKeyResourceMap, resourceDetails);
                    if (headerResourceMap != null) {
                        InitWebSubSubscriberServiceEndpoint.populateResourceDetailsByHeader(headerResourceMap, resourceDetails);
                    }
                    if (payloadKeyResourceMap == null) break;
                    InitWebSubSubscriberServiceEndpoint.populateResourceDetailsByPayload(payloadKeyResourceMap, resourceDetails);
                }
            }
        }
        return resourceDetails;
    }

    private static void populateResourceDetailsByHeader(MapValue<String, Object> headerResourceMap, HashMap<String, BRecordType> resourceDetails) {
        headerResourceMap.values().forEach(value -> InitWebSubSubscriberServiceEndpoint.populateResourceDetails(resourceDetails, (ArrayValue)value));
    }

    private static void populateResourceDetailsByPayload(MapValue<String, MapValue<String, Object>> payloadKeyResourceMap, HashMap<String, BRecordType> resourceDetails) {
        payloadKeyResourceMap.values().forEach(mapByKey -> mapByKey.values().forEach(value -> InitWebSubSubscriberServiceEndpoint.populateResourceDetails(resourceDetails, (ArrayValue)value)));
    }

    private static void populateResourceDetailsByHeaderAndPayload(MapValue<String, MapValue<String, MapValue<String, Object>>> headerAndPayloadKeyResourceMap, HashMap<String, BRecordType> resourceDetails) {
        headerAndPayloadKeyResourceMap.values().forEach(mapByHeader -> mapByHeader.values().forEach(mapByKey -> mapByKey.values().forEach(value -> InitWebSubSubscriberServiceEndpoint.populateResourceDetails(resourceDetails, (ArrayValue)value))));
    }

    private static void populateResourceDetails(HashMap<String, BRecordType> resourceDetails, ArrayValue resourceDetailTuple) {
        String resourceName = resourceDetailTuple.getRefValue(0L).toString();
        resourceDetails.put(resourceName, (BRecordType)((TypedescValue)resourceDetailTuple.getRefValue(1L)).getDescribingType());
    }
}

