/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.websub.WebSubHttpService;
import org.ballerinalang.net.websub.WebSubServicesRegistry;
import org.wso2.transport.http.netty.contract.ServerConnector;

@BallerinaFunction(orgName="ballerina", packageName="websub", functionName="retrieveSubscriptionParameters", receiver=@Receiver(type=TypeKind.OBJECT, structType="Listener", structPackage="ballerina/websub"), returnType={@ReturnType(type=TypeKind.ARRAY)})
public class RetrieveSubscriptionParameters {
    private static final String LOCALHOST = "localhost";

    public static ArrayValue retrieveSubscriptionParameters(Strand strand, ObjectValue subscriberServiceEndpoint) {
        ArrayValue subscriptionDetailArray = new ArrayValue((BType)new BArrayType((BType)new BMapType(BTypes.typeAny)));
        ObjectValue serviceEndpoint = (ObjectValue)subscriberServiceEndpoint.get("serviceEndpoint");
        WebSubServicesRegistry webSubServicesRegistry = (WebSubServicesRegistry)((Object)serviceEndpoint.getNativeData("WEBSUB_SERVICE_REGISTRY"));
        if (webSubServicesRegistry.getServicesMapHolder("b7a.default") == null) {
            return subscriptionDetailArray;
        }
        Object[] webSubHttpServices = webSubServicesRegistry.getServicesByHost("b7a.default").values().toArray();
        for (int index = 0; index < webSubHttpServices.length; ++index) {
            String callback;
            WebSubHttpService webSubHttpService = (WebSubHttpService)((Object)webSubHttpServices[index]);
            MapValueImpl subscriptionDetails = new MapValueImpl();
            MapValue annotation = (MapValue)webSubHttpService.getBalService().getType().getAnnotation("ballerina/websub", "SubscriberServiceConfig");
            subscriptionDetails.put((Object)"webSubServiceName", (Object)webSubHttpService.getBalService().getType().getName());
            subscriptionDetails.put((Object)"subscribeOnStartUp", (Object)annotation.getBooleanValue("subscribeOnStartUp"));
            if (annotation.containsKey((Object)"target")) {
                subscriptionDetails.put((Object)"target", annotation.get((Object)"target"));
            }
            if (annotation.containsKey((Object)"leaseSeconds")) {
                subscriptionDetails.put((Object)"leaseSeconds", (Object)annotation.getIntValue("leaseSeconds"));
            }
            if (annotation.containsKey((Object)"secret")) {
                subscriptionDetails.put((Object)"secret", (Object)annotation.getStringValue("secret"));
            }
            if (annotation.containsKey((Object)"publisherClientConfig")) {
                MapValue publisherClientConfig = (MapValue)annotation.get((Object)"publisherClientConfig");
                subscriptionDetails.put((Object)"publisherClientConfig", (Object)publisherClientConfig);
            }
            if (annotation.containsKey((Object)"hubClientConfig")) {
                MapValue hubClientConfig = (MapValue)annotation.get((Object)"hubClientConfig");
                subscriptionDetails.put((Object)"hubClientConfig", (Object)hubClientConfig);
            }
            if (annotation.containsKey((Object)"callback")) {
                callback = annotation.getStringValue("callback");
            } else {
                callback = webSubHttpService.getBasePath();
                MapValue serviceEndpointConfig = (MapValue)serviceEndpoint.get("config");
                long port = serviceEndpoint.getIntValue("port");
                callback = !serviceEndpointConfig.getStringValue("host").isEmpty() && port != 0L ? serviceEndpointConfig.getStringValue("host") + ":" + port + callback : ((ServerConnector)serviceEndpoint.getNativeData("HTTP_SERVER_CONNECTOR")).getConnectorID() + callback;
                if (callback.startsWith("0.0.0.0")) {
                    callback = callback.replace("0.0.0.0", LOCALHOST);
                }
                if (!callback.contains("://")) {
                    callback = serviceEndpointConfig.get((Object)"secureSocket") != null ? "https://".concat(callback) : "http://".concat(callback);
                }
            }
            subscriptionDetails.put((Object)"callback", (Object)callback);
            subscriptionDetailArray.add((long)index, (Object)subscriptionDetails);
        }
        return subscriptionDetailArray;
    }
}

