/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.nativeimpl;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.websub.BallerinaWebSubException;
import org.ballerinalang.net.websub.WebSubUtils;
import org.ballerinalang.net.websub.hub.Hub;

@BallerinaFunction(orgName="ballerina", packageName="websub", functionName="validateAndPublishToInternalHub", args={@Argument(name="hubUrl", type=TypeKind.STRING), @Argument(name="topic", type=TypeKind.STRING), @Argument(name="content", type=TypeKind.OBJECT)}, returnType={@ReturnType(type=TypeKind.OBJECT)})
public class ValidateAndPublishToInternalHub {
    public static Object validateAndPublishToInternalHub(Strand strand, String hubUrl, String topic, MapValue<String, Object> content) {
        Hub hubInstance = Hub.getInstance();
        if (hubInstance.isStarted() && hubInstance.getHubUrl().equals(hubUrl)) {
            try {
                Hub.getInstance().publish(topic, content);
            }
            catch (BallerinaWebSubException e) {
                return WebSubUtils.createError(e.getMessage());
            }
            return null;
        }
        return WebSubUtils.createError("Internal Ballerina Hub not initialized or incorrectly referenced");
    }
}

