/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.hub;

import io.netty.buffer.ByteBuf;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.net.websub.BallerinaWebSubException;
import org.ballerinalang.net.websub.WebSubSubscriberConstants;
import org.ballerinalang.net.websub.broker.BallerinaBroker;
import org.ballerinalang.net.websub.broker.BallerinaBrokerByteBuf;
import org.ballerinalang.net.websub.hub.HubSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hub {
    private static final Logger logger = LoggerFactory.getLogger(Hub.class);
    private static Hub instance = new Hub();
    private BallerinaBroker brokerInstance = null;
    private ObjectValue hubObject = null;
    private String publishUrl;
    private String subscribeUrl;
    private boolean hubTopicRegistrationRequired;
    private volatile boolean started = false;
    private List<String> topics = new ArrayList<String>();
    private List<HubSubscriber> subscribers = new ArrayList<HubSubscriber>();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private String basePath = "/";
    private String publishResourcePath = "/publish";
    private String subscribeResourcePath = "/";
    private static final String HUB_SERVICE = "hub_service";
    private static final String SLASH = "/";

    public static Hub getInstance() {
        return instance;
    }

    private Hub() {
    }

    public String getPublishUrl() {
        return this.publishUrl;
    }

    public ObjectValue getHubObject() {
        return this.hubObject;
    }

    public void registerTopic(String topic) throws BallerinaWebSubException {
        if (this.isTopicRegistered(topic)) {
            throw new BallerinaWebSubException("Topic registration not allowed at the Hub: topic already exists");
        }
        if (topic == null || topic.isEmpty()) {
            throw new BallerinaWebSubException("Topic unavailable/invalid for registration at Hub");
        }
        this.topics.add(topic);
    }

    public void unregisterTopic(String topic) throws BallerinaWebSubException {
        if (topic == null || !this.isTopicRegistered(topic)) {
            throw new BallerinaWebSubException("Topic unavailable/invalid for unregistration at Hub");
        }
        this.topics.remove(topic);
    }

    public boolean isTopicRegistered(String topic) {
        return this.topics.contains(topic);
    }

    public void registerSubscription(Strand strand, String topic, String callback, MapValue<String, Object> subscriptionDetails) {
        if (!this.started) {
            logger.error("Hub Service not started: subscription failed");
        } else if (!this.topics.contains(topic) && this.hubTopicRegistrationRequired) {
            logger.warn("Subscription request ignored for unregistered topic[" + topic + "]");
        } else {
            if (this.getSubscribers().contains((Object)new HubSubscriber(strand, "", topic, callback, null))) {
                this.unregisterSubscription(strand, topic, callback);
            }
            String queue = UUID.randomUUID().toString();
            HubSubscriber subscriberToAdd = new HubSubscriber(strand, queue, topic, callback, subscriptionDetails);
            this.brokerInstance.addSubscription(topic, subscriberToAdd);
            this.getSubscribers().add(subscriberToAdd);
        }
    }

    public void unregisterSubscription(Strand strand, String topic, String callback) {
        if (!this.started) {
            logger.error("Hub Service not started: unsubscription failed.");
            return;
        }
        HubSubscriber subscriberToUnregister = new HubSubscriber(strand, "", topic, callback, null);
        if (!this.getSubscribers().contains((Object)subscriberToUnregister)) {
            if (callback.endsWith(SLASH)) {
                this.unregisterSubscription(strand, topic, callback.substring(0, callback.length() - 1));
            }
            return;
        }
        List<HubSubscriber> currentSubscriberList = this.getSubscribers();
        for (HubSubscriber subscriber : currentSubscriberList) {
            if (!subscriber.equals((Object)subscriberToUnregister)) continue;
            subscriberToUnregister = subscriber;
            break;
        }
        this.brokerInstance.removeSubscription(subscriberToUnregister);
        this.getSubscribers().remove((Object)subscriberToUnregister);
    }

    public void publish(String topic, MapValue<String, Object> content) throws BallerinaWebSubException {
        if (!this.started) {
            throw new BallerinaWebSubException("Hub Service not started: publish failed");
        }
        if (!this.topics.contains(topic) && this.hubTopicRegistrationRequired) {
            throw new BallerinaWebSubException("Publish call ignored for unregistered topic[" + topic + "]");
        }
        this.brokerInstance.publish(topic, (ByteBuf)new BallerinaBrokerByteBuf(content));
    }

    public boolean isStarted() {
        return this.started;
    }

    public Object startUpHubService(Strand strand, String basePath, String subscriptionResourcePath, String publishResourcePath, boolean topicRegistrationRequired, String publicUrl, ObjectValue hubListener) {
        Hub hub = this;
        synchronized (hub) {
            if (!this.isStarted()) {
                try {
                    this.brokerInstance = BallerinaBroker.getBrokerInstance();
                }
                catch (Exception e) {
                    throw new BallerinaException("Error starting up internal broker for WebSub Hub");
                }
                this.basePath = basePath.startsWith(SLASH) ? basePath : SLASH.concat(basePath);
                this.subscribeResourcePath = subscriptionResourcePath.startsWith(SLASH) ? subscriptionResourcePath : SLASH.concat(subscriptionResourcePath);
                this.publishResourcePath = publishResourcePath.startsWith(SLASH) ? publishResourcePath : SLASH.concat(publishResourcePath);
                this.hubTopicRegistrationRequired = topicRegistrationRequired;
                String publishUrl = this.populatePublishUrl(publicUrl, hubListener);
                String subscribeUrl = this.populateSubscribeUrl(publicUrl, hubListener);
                this.started = true;
                Object setupResult = Executor.executeFunction((Scheduler)strand.scheduler, (ClassLoader)this.classLoader, (String)"ballerina", (String)"websub", (String)HUB_SERVICE, (String)"setupOnStartup", (Object[])new Object[0]);
                if (TypeChecker.getType((Object)setupResult).getTag() == 27) {
                    this.started = false;
                    return setupResult;
                }
                PrintStream console = System.err;
                console.println("[ballerina/websub] Ballerina WebSub Hub started up.\n[ballerina/websub] Publish URL: " + publishUrl + "\n[ballerina/websub] Subscription URL: " + subscribeUrl);
                this.setPublishUrl(publishUrl);
                this.setSubscribeUrl(subscribeUrl);
                ObjectValue hubObject = BallerinaValues.createObjectValue((BPackage)WebSubSubscriberConstants.WEBSUB_PACKAGE_ID, (String)"Hub", (Object[])new Object[]{subscribeUrl, publishUrl, hubListener});
                this.setHubObject(hubObject);
                return hubObject;
            }
            throw new BallerinaWebSubException("Hub Service already started up");
        }
    }

    private String populatePublishUrl(String publicUrl, ObjectValue hubListener) {
        if (publicUrl.isEmpty()) {
            String hubPort = String.valueOf(hubListener.get("port"));
            Object secureSocket = ((MapValue)hubListener.get("config")).get((Object)"secureSocket");
            String path = this.basePath.equals(SLASH) ? this.publishResourcePath : this.basePath.concat(this.publishResourcePath);
            return secureSocket != null ? "https://localhost:" + hubPort + path : "http://localhost:" + hubPort + path;
        }
        return publicUrl.concat(this.basePath.equals(SLASH) ? this.publishResourcePath : this.basePath.concat(this.publishResourcePath));
    }

    private String populateSubscribeUrl(String publicUrl, ObjectValue hubListener) {
        if (publicUrl.isEmpty()) {
            String hubPort = String.valueOf(hubListener.get("port"));
            Object secureSocket = ((MapValue)hubListener.get("config")).get((Object)"secureSocket");
            String path = this.basePath.equals(SLASH) ? this.subscribeResourcePath : this.basePath.concat(this.subscribeResourcePath);
            return secureSocket != null ? "https://localhost:" + hubPort + path : "http://localhost:" + hubPort + path;
        }
        return publicUrl.concat(this.basePath.equals(SLASH) ? this.subscribeResourcePath : this.basePath.concat(this.subscribeResourcePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHubService() {
        Hub hub = this;
        synchronized (hub) {
            if (this.isStarted()) {
                this.started = false;
                this.setHubObject(null);
                this.setSubscribeUrl(null);
                this.setPublishUrl(null);
                this.hubTopicRegistrationRequired = false;
                this.topics = new ArrayList<String>();
                for (HubSubscriber subscriber : this.getSubscribers()) {
                    this.brokerInstance.removeSubscription(subscriber);
                }
            } else {
                throw new BallerinaWebSubException("error stopping the hub service: already stopped");
            }
            this.subscribers = new ArrayList<HubSubscriber>();
            this.brokerInstance = null;
        }
    }

    private void setSubscribeUrl(String subscribeUrl) {
        this.subscribeUrl = subscribeUrl;
    }

    private void setPublishUrl(String publishUrl) {
        this.publishUrl = publishUrl;
    }

    private void setHubObject(ObjectValue hubObject) {
        this.hubObject = hubObject;
    }

    public String[] getTopics() {
        return this.topics.toArray(new String[0]);
    }

    public List<HubSubscriber> getSubscribers() {
        return this.subscribers;
    }
}

