/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub;

import java.util.List;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

public class WebSubSubscriberServiceValidator {
    private static final int CUSTOM_RESOURCE_PARAM_COUNT = 2;

    public static void validateDefaultResources(BLangFunction resource, DiagnosticLog dlog) {
        String resourceName;
        switch (resourceName = resource.getName().getValue()) {
            case "onIntentVerification": {
                WebSubSubscriberServiceValidator.validateOnIntentVerificationResource(resource, dlog);
                break;
            }
            case "onNotification": {
                WebSubSubscriberServiceValidator.validateOnNotificationResource(resource, dlog);
                break;
            }
            default: {
                dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.getPosition(), (CharSequence)("invalid resource name '" + resourceName + "' only two resources allowed with " + "ballerina/websub" + ":" + "Service" + ", '" + "onIntentVerification" + "' and '" + "onNotification" + "'"));
            }
        }
    }

    private static void validateOnIntentVerificationResource(BLangFunction resource, DiagnosticLog dlog) {
        List paramDetails = resource.getParameters();
        if (WebSubSubscriberServiceValidator.isValidParamNumber(resource, paramDetails, 2, resource.getName().getValue(), dlog)) {
            WebSubSubscriberServiceValidator.validateStructType(resource.getName().getValue(), (BLangSimpleVariable)paramDetails.get(0), "ballerina/websub", "Caller", "first", dlog);
            WebSubSubscriberServiceValidator.validateStructType(resource.getName().getValue(), (BLangSimpleVariable)paramDetails.get(1), "ballerina/websub", "IntentVerificationRequest", "second", dlog);
        }
    }

    private static void validateOnNotificationResource(BLangFunction resource, DiagnosticLog dlog) {
        List paramDetails = resource.getParameters();
        if (WebSubSubscriberServiceValidator.isValidParamNumber(resource, paramDetails, 1, resource.getName().getValue(), dlog)) {
            WebSubSubscriberServiceValidator.validateStructType(resource.getName().getValue(), (BLangSimpleVariable)paramDetails.get(0), "ballerina/websub", "Notification", "first", dlog);
        }
    }

    private static boolean isValidParamNumber(BLangFunction resource, List<BLangSimpleVariable> paramDetails, int expectedSize, String resourceName, DiagnosticLog dlog) {
        if (paramDetails == null || paramDetails.size() != expectedSize) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("invalid param count for WebSub Resource '" + resourceName + "', expected: " + expectedSize + " found: " + (paramDetails == null ? 0 : paramDetails.size())));
            return false;
        }
        return true;
    }

    private static void validateStructType(String resourceName, BLangSimpleVariable paramDetail, String packageName, String structuralTypeName, String paramPosition, DiagnosticLog dlog) {
        if (!packageName.concat(":").concat(structuralTypeName).equals(paramDetail.type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)paramDetail.pos, (CharSequence)("invalid resource signature for '" + resourceName + "', expected '" + packageName.concat(":").concat(structuralTypeName) + "' as " + paramPosition + " parameter"));
        }
    }
}

