/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.websub.broker;

import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.config.BrokerCommonConfiguration;
import io.ballerina.messaging.broker.common.config.BrokerConfigProvider;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.BrokerImpl;
import io.ballerina.messaging.broker.core.Consumer;
import io.ballerina.messaging.broker.core.ContentChunk;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.Metadata;
import io.ballerina.messaging.broker.core.configuration.BrokerCoreConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallerinaBroker {
    private static final Logger logger = LoggerFactory.getLogger(BallerinaBroker.class);
    private static BallerinaBroker instance = null;
    private BrokerImpl broker = null;

    private BallerinaBroker(BrokerImpl broker) {
        this.broker = broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BallerinaBroker getBrokerInstance() throws Exception {
        if (instance != null) {
            return instance;
        }
        Class<BallerinaBroker> clazz = BallerinaBroker.class;
        synchronized (BallerinaBroker.class) {
            if (instance == null) {
                BallerinaBroker.startInternalBroker();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addSubscription(String topic, Consumer consumer) {
        String queueName = consumer.getQueueName();
        try {
            this.broker.createQueue(queueName, false, false, true);
            this.broker.bind(queueName, "amq.topic", topic, FieldTable.EMPTY_TABLE);
            this.broker.addConsumer(consumer);
        }
        catch (ValidationException | BrokerException e) {
            logger.error("Error adding subscription: ", e);
        }
    }

    public void removeSubscription(Consumer consumer) {
        this.broker.removeConsumer(consumer);
    }

    public void publish(String topic, byte[] payload) {
        Message message = new Message(Broker.getNextMessageId(), new Metadata(topic, "amq.topic", (long)payload.length));
        ByteBuf content = Unpooled.copiedBuffer((byte[])payload);
        message.addChunk(new ContentChunk(0L, content));
        try {
            this.broker.publish(message);
        }
        catch (BrokerException e) {
            logger.error("Error publishing to topic: ", (Throwable)e);
        }
    }

    public void publish(String topic, ByteBuf payload) {
        Message message = new Message(Broker.getNextMessageId(), new Metadata(topic, "amq.topic", (long)payload.array().length));
        message.addChunk(new ContentChunk(0L, payload));
        try {
            this.broker.publish(message);
        }
        catch (BrokerException e) {
            logger.error("Error publishing to topic: ", (Throwable)e);
        }
    }

    private static void startInternalBroker() throws Exception {
        BallerinaBrokerConfigProvider configProvider = new BallerinaBrokerConfigProvider();
        BrokerCommonConfiguration brokerCommonConfiguration = new BrokerCommonConfiguration();
        brokerCommonConfiguration.setEnableInMemoryMode(true);
        configProvider.registerConfigurationObject("ballerina.broker", brokerCommonConfiguration);
        BrokerCoreConfiguration brokerCoreConfiguration = new BrokerCoreConfiguration();
        configProvider.registerConfigurationObject("ballerina.broker.core", brokerCoreConfiguration);
        StartupContext startupContext = new StartupContext();
        startupContext.registerService(BrokerConfigProvider.class, (Object)configProvider);
        BrokerImpl broker = new BrokerImpl(startupContext);
        broker.startMessageDelivery();
        instance = new BallerinaBroker(broker);
    }

    private static class BallerinaBrokerConfigProvider
    implements BrokerConfigProvider {
        private Map<String, Object> configMap = new HashMap<String, Object>();

        private BallerinaBrokerConfigProvider() {
        }

        public <T> T getConfigurationObject(String namespace, Class<T> configurationClass) throws Exception {
            return configurationClass.cast(this.configMap.get(namespace));
        }

        void registerConfigurationObject(String namespace, Object configObject) {
            this.configMap.put(namespace, configObject);
        }
    }
}

