/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.xslt;

import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltTransformer {
    private static final Logger log = LoggerFactory.getLogger(XsltTransformer.class);
    private static final String XSLT_ERROR_RECORD = "XSLTError";
    private static final String XSLT_ERROR_CODE = "{ballerina/xslt}XSLTError";
    private static final String OPERATION = "Failed to perform XSL transformation: ";

    public static Object transform(XMLValue xmlInput, XMLValue xslInput) {
        try {
            boolean unwrap = false;
            if (xmlInput.getNodeType() == XMLNodeType.SEQUENCE) {
                XMLItem wrapper = new XMLItem(new QName("root"), (XMLSequence)xmlInput);
                xmlInput = wrapper;
                unwrap = true;
            }
            String input = xmlInput.toString();
            if (unwrap) {
                input = input.substring(6, input.length() - 7).trim();
            }
            String xsl = xslInput.toString();
            OMElement omXML = AXIOMUtil.stringToOM((String)input);
            OMElement omXSL = AXIOMUtil.stringToOM((String)xsl);
            StAXSource xmlSource = new StAXSource(omXML.getXMLStreamReader());
            StAXSource xslSource = new StAXSource(omXSL.getXMLStreamReader());
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(xmlSource, streamResult);
            String resultStr = stringWriter.getBuffer().toString().trim();
            if (log.isDebugEnabled()) {
                log.debug("Transformed result : {}", (Object)resultStr);
            }
            if (resultStr.isEmpty()) {
                return XsltTransformer.createError(XSLT_ERROR_CODE, "Failed to perform XSL transformation: empty result");
            }
            return XsltTransformer.parseToXML(resultStr);
        }
        catch (ClassCastException e) {
            return XsltTransformer.createError(XSLT_ERROR_CODE, "Failed to perform XSL transformation: invalid inputs(s)");
        }
        catch (Exception e) {
            String errMsg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            return XsltTransformer.createError(XSLT_ERROR_CODE, OPERATION + errMsg);
        }
    }

    private static XMLSequence parseToXML(String xmlStr) throws XMLStreamException {
        return (XMLSequence)XMLFactory.parse((String)xmlStr);
    }

    private static ErrorValue createError(String reason, String errMsg) {
        return BallerinaErrors.createError((String)reason, (String)errMsg);
    }
}

