/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.composer.service.logging.service;

import com.google.gson.JsonObject;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.ballerinalang.composer.server.spi.ComposerService;
import org.ballerinalang.composer.server.spi.ServiceInfo;
import org.ballerinalang.composer.server.spi.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/composer/logging")
public class LoggingService
implements ComposerService {
    private static final Logger logger = LoggerFactory.getLogger(LoggingService.class);

    @POST
    @Path(value="/log")
    @Produces(value={"application/json"})
    public Response log(@FormParam(value="logger") String loggerID, @FormParam(value="timestamp") String timestamp, @FormParam(value="level") String level, @FormParam(value="url") String url, @FormParam(value="message") String message, @FormParam(value="layout") String layout) {
        try {
            this.logToSLF4J(loggerID, timestamp, level, url, message, layout);
            JsonObject entity = new JsonObject();
            entity.addProperty("status", "success");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).header("Access-Control-Allow-Origin", (Object)Character.valueOf('*')).type("application/json").build();
        }
        catch (Throwable throwable) {
            logger.error("/log service error", (Object)throwable.getMessage(), (Object)throwable);
            JsonObject entity = new JsonObject();
            entity.addProperty("status", "error");
            entity.addProperty("error", throwable.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)entity).header("Access-Control-Allow-Origin", (Object)Character.valueOf('*')).type("application/json").build();
        }
    }

    private void logToSLF4J(String loggerID, String timestamp, String level, String url, String message, String layout) {
        Logger frontEndLog = LoggerFactory.getLogger((String)loggerID);
        String logMessage = "client-timestamp: " + timestamp + ", page: " + url + ", message: " + message;
        switch (level) {
            case "TRACE": {
                frontEndLog.trace(logMessage);
                break;
            }
            case "INFO": {
                frontEndLog.info(logMessage);
                break;
            }
            case "WARN": {
                frontEndLog.warn(logMessage);
                break;
            }
            case "ERROR": 
            case "FATAL": {
                frontEndLog.error(logMessage);
                break;
            }
            default: {
                frontEndLog.debug(logMessage);
            }
        }
    }

    public ServiceInfo getServiceInfo() {
        return new ServiceInfo("logging", "logging", ServiceType.HTTP);
    }
}

