/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import org.ballerinalang.launcher.BLauncherCmd;

@Parameters(commandNames={"doc"}, commandDescription="generate Ballerina API documentation")
public class BallerinaDocCmd
implements BLauncherCmd {
    private final PrintStream out = System.out;
    private JCommander parentCmdParser;
    @Parameter(arity=1, description="either the path to the directories where Ballerina source files reside or a path to a Ballerina file which does not belong to a package")
    private List<String> argList;
    @Parameter(names={"--output", "-o"}, description="path to the output directory where the API documentation will be written to", hidden=false)
    private String outputDir;
    @Parameter(names={"--template", "-t"}, description="path to a custom templates directory to be used for API documentation generation", hidden=false)
    private String templatesDir;
    @Parameter(names={"--exclude", "-e"}, description="a comma separated list of package names to be filtered from the documentation", hidden=false)
    private String packageFilter;
    @Parameter(names={"--native", "-n"}, description="read the source as native ballerina code", hidden=false)
    private boolean nativeSource;
    @Parameter(names={"--verbose", "-v"}, description="enable debug level logs", hidden=false)
    private boolean debugEnabled;
    @Parameter(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"doc");
            this.out.println(commandUsageInfo);
            return;
        }
        if (this.argList == null || this.argList.size() == 0) {
            StringBuilder sb = new StringBuilder("docerina: no valid Ballerina source given." + System.lineSeparator());
            sb.append(BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"doc"));
            this.out.println(sb);
            return;
        }
        if (this.debugEnabled) {
            System.setProperty("debugDocerina", "true");
        }
        if (this.templatesDir != null) {
            System.setProperty("templates.folder.path", this.templatesDir);
        }
        String[] sources = this.argList.toArray(new String[this.argList.size()]);
        BallerinaDocGenerator.generateApiDocs(this.outputDir, this.packageFilter, this.nativeSource, sources);
    }

    public String getName() {
        return "doc";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Generates the API documentation of give Ballerina programs." + System.lineSeparator());
        out.append(System.lineSeparator());
    }

    public void printUsage(StringBuilder stringBuilder) {
        stringBuilder.append("ballerina doc <sourcepath>... [-t templatesdir] [-o outputdir] [-n] [-e excludedpackages] [-v]" + System.lineSeparator()).append("  sourcepath:" + System.lineSeparator()).append("  Paths to the directories where Ballerina source files reside or a path to" + System.lineSeparator()).append("  a Ballerina file which does not belong to a package" + System.lineSeparator());
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }
}

