/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.docs.utils;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BallerinaDocUtils {
    private static final boolean debugEnabled = "true".equals(System.getProperty("debugDocerina"));
    private static final PrintStream out = System.out;

    public static void packageToZipFile(String sourceDirPath, String zipFilePath) throws IOException {
        Path p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Path pp = Paths.get(sourceDirPath, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path2 -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path2).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path2, zs);
                    zs.closeEntry();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    public static void copyResources(String resource, String targetPath) throws IOException {
        Path source;
        URI uri = null;
        try {
            uri = BallerinaDocUtils.class.getClassLoader().getResource(resource).toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to load resources: " + e.getMessage(), e);
        }
        try {
            source = Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            FileSystems.newFileSystem(uri, env);
            source = Paths.get(uri);
        }
        Path target = Paths.get(targetPath, resource);
        Files.walkFileTree(source, new RecursiveFileVisitor(source, target));
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    static class RecursiveFileVisitor
    extends SimpleFileVisitor<Path> {
        Path source;
        Path target;

        public RecursiveFileVisitor(Path aSource, Path aTarget) {
            this.source = aSource;
            this.target = aTarget;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            block2: {
                Path targetdir = this.target.resolve(this.source.relativize(dir).toString());
                try {
                    Files.copy(dir, targetdir, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException e) {
                    if (Files.isDirectory(targetdir, new LinkOption[0])) break block2;
                    throw e;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.target.resolve(this.source.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
            if (BallerinaDocUtils.isDebugEnabled()) {
                out.println("File copied: " + file.toString());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

