/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.ballerinalang.docgen.model.AnnotationDoc;
import org.ballerinalang.docgen.model.ConnectorDoc;
import org.ballerinalang.docgen.model.Documentable;
import org.ballerinalang.docgen.model.EnumDoc;
import org.ballerinalang.docgen.model.FunctionDoc;
import org.ballerinalang.docgen.model.GlobalVariableDoc;
import org.ballerinalang.docgen.model.PrimitiveTypeDoc;
import org.ballerinalang.docgen.model.RecordDoc;

public class Writer {
    private static PrintStream out = System.out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHtmlDocument(Object object, String packageTemplateName, String filePath) {
        String templatesFolderPath = System.getProperty("templates.folder.path", File.separator + "docerina-templates" + File.separator + "html");
        try (PrintWriter writer = null;){
            Handlebars handlebars = new Handlebars().with(new ClassPathTemplateLoader(templatesFolderPath), new FileTemplateLoader(templatesFolderPath));
            handlebars.registerHelpers((Class)StringHelpers.class);
            handlebars.registerHelper("exists", new Helper<List<Documentable>>(){

                @Override
                public Object apply(List<Documentable> context, Options options) throws IOException {
                    String construct;
                    switch (construct = (String)options.param(0)) {
                        case "primitive": {
                            return context.stream().anyMatch(c -> c instanceof PrimitiveTypeDoc) ? options.fn(this) : options.inverse(this);
                        }
                        case "type": {
                            return context.stream().anyMatch(c -> c instanceof EnumDoc) ? options.fn(this) : options.inverse(this);
                        }
                        case "annotation": {
                            return context.stream().anyMatch(c -> c instanceof AnnotationDoc) ? options.fn(this) : options.inverse(this);
                        }
                        case "record": {
                            return context.stream().anyMatch(c -> c instanceof RecordDoc) ? options.fn(this) : options.inverse(this);
                        }
                        case "object": {
                            return context.stream().anyMatch(c -> {
                                if (c instanceof ConnectorDoc) {
                                    ConnectorDoc connectorDoc = (ConnectorDoc)c;
                                    if (connectorDoc.isObject) {
                                        return true;
                                    }
                                }
                                return false;
                            }) ? options.fn(this) : options.inverse(this);
                        }
                        case "endpoint": {
                            return context.stream().anyMatch(c -> {
                                if (c instanceof ConnectorDoc) {
                                    ConnectorDoc connectorDoc = (ConnectorDoc)c;
                                    if (connectorDoc.isConnector) {
                                        return true;
                                    }
                                }
                                return false;
                            }) ? options.fn(this) : options.inverse(this);
                        }
                        case "function": {
                            return context.stream().anyMatch(c -> c instanceof FunctionDoc) ? options.fn(this) : options.inverse(this);
                        }
                        case "globalvar": {
                            return context.stream().anyMatch(c -> c instanceof GlobalVariableDoc) ? options.fn(this) : options.inverse(this);
                        }
                    }
                    return false;
                }
            });
            Template template = handlebars.compile(packageTemplateName);
            writer = new PrintWriter(filePath, "UTF-8");
            Context context = Context.newBuilder(object).resolver(FieldValueResolver.INSTANCE).build();
            writer.println(template.apply(context));
            out.println("HTML file written: " + filePath);
        }
    }
}

