/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.cmd;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.launcher.LauncherUtils;
import org.wso2.ballerinalang.compiler.FileSystemProjectDirectory;

@Parameters(commandNames={"doc"}, commandDescription="generate Ballerina API documentation")
public class BallerinaDocCmd
implements BLauncherCmd {
    private final PrintStream out = System.out;
    private JCommander parentCmdParser;
    @Parameter(arity=1, description="either the path to the directories where Ballerina source files reside or a path to a Ballerina file which does not belong to a package")
    private List<String> argList;
    @Parameter(names={"--output", "-o"}, description="path to the output directory where the API documentation will be written to", hidden=false)
    private String outputDir;
    @Parameter(names={"--template", "-t"}, description="path to a custom templates directory to be used for API documentation generation", hidden=false)
    private String templatesDir;
    @Parameter(names={"--exclude", "-e"}, description="a comma separated list of package names to be filtered from the documentation", hidden=false)
    private String packageFilter;
    @Parameter(names={"--native", "-n"}, description="read the source as native ballerina code", hidden=false)
    private boolean nativeSource;
    @DynamicParameter(names={"-e"}, description="Ballerina environment parameters")
    private Map<String, String> runtimeParams = new HashMap<String, String>();
    @Parameter(names={"--config", "-c"}, description="path to the docerina configuration file")
    private String configFilePath;
    @Parameter(names={"--verbose", "-v"}, description="enable debug level logs", hidden=false)
    private boolean debugEnabled;
    @Parameter(names={"--sourceroot"}, description="path to the directory containing source files and packages")
    private String sourceRoot;
    @Parameter(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((JCommander)this.parentCmdParser, (String)"doc");
            this.out.println(commandUsageInfo);
            return;
        }
        Path sourceRootPath = LauncherUtils.getSourceRootPath((String)this.sourceRoot);
        if (this.argList == null || this.argList.isEmpty()) {
            FileSystemProjectDirectory srcDirectory = new FileSystemProjectDirectory(sourceRootPath);
            this.argList = srcDirectory.getSourcePackageNames();
        }
        if (this.debugEnabled) {
            System.setProperty("debugDocerina", "true");
        }
        if (this.templatesDir != null) {
            System.setProperty("templates.folder.path", this.templatesDir);
        }
        try {
            ConfigRegistry.getInstance().initRegistry(this.runtimeParams, this.configFilePath, null);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read the specified configuration file: " + this.configFilePath, e);
        }
        String[] sources = this.argList.toArray(new String[this.argList.size()]);
        BallerinaDocGenerator.generateApiDocs(sourceRootPath.toString(), this.outputDir, this.packageFilter, this.nativeSource, sources);
    }

    public String getName() {
        return "doc";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Generates the API documentation of give Ballerina programs." + System.lineSeparator());
        out.append(System.lineSeparator());
    }

    public void printUsage(StringBuilder stringBuilder) {
        stringBuilder.append("ballerina doc <sourcepath>... [-t templatesdir] [-o outputdir] [-n] [-e excludedpackages] [-v]" + System.lineSeparator()).append("  sourcepath:" + System.lineSeparator()).append("  Paths to the directories where Ballerina source files reside or a path to" + System.lineSeparator()).append("  a Ballerina file which does not belong to a package" + System.lineSeparator());
    }

    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    public void setSelfCmdParser(JCommander selfCmdParser) {
    }
}

