/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.model;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.ballerinalang.docgen.model.Documentable;
import org.ballerinalang.docgen.model.Field;
import org.ballerinalang.docgen.model.FunctionDoc;
import org.wso2.ballerinalang.compiler.tree.BLangObject;

public class ConnectorDoc
extends Documentable {
    public final boolean isConnector;
    public final boolean isObject;
    public final boolean hasConstructor;
    public final List<Field> fields;
    private BLangObject object;

    public ConnectorDoc(String name, String description, List<Documentable> children, List<Field> fields, List<Documentable> utilityFunctions, boolean isConnector, boolean hasConstructor) {
        super(name, "fw-endpoint", description, children);
        if (!isConnector) {
            this.icon = "fw-struct";
        }
        if (isConnector) {
            for (Documentable doc : children) {
                doc.icon = "fw-action";
            }
        }
        children.addAll(utilityFunctions);
        this.fields = fields;
        this.isConnector = isConnector;
        this.isObject = !isConnector;
        this.hasConstructor = hasConstructor;
        List filteredChildren = children.stream().filter(f -> {
            if (f instanceof FunctionDoc) {
                FunctionDoc functionDoc = (FunctionDoc)f;
                return this.isNotAFilteredFunction(functionDoc.name);
            }
            return true;
        }).collect(Collectors.toList());
        children.clear();
        children.addAll(filteredChildren);
    }

    public BLangObject getObject() {
        return this.object;
    }

    public void setObject(BLangObject object) {
        this.object = object;
    }

    private boolean isNotAFilteredFunction(String name) {
        return !EnumUtils.isValidEnum(FilteredFunctions.class, (String)name);
    }

    private static enum FilteredFunctions {
        init,
        register,
        start,
        stop,
        getCallerActions;

    }
}

