/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.generator.model.Annotation;
import org.ballerinalang.docgen.generator.model.Client;
import org.ballerinalang.docgen.generator.model.Constant;
import org.ballerinalang.docgen.generator.model.DefaultableVariable;
import org.ballerinalang.docgen.generator.model.Error;
import org.ballerinalang.docgen.generator.model.FiniteType;
import org.ballerinalang.docgen.generator.model.Function;
import org.ballerinalang.docgen.generator.model.Listener;
import org.ballerinalang.docgen.generator.model.Module;
import org.ballerinalang.docgen.generator.model.Object;
import org.ballerinalang.docgen.generator.model.Record;
import org.ballerinalang.docgen.generator.model.Type;
import org.ballerinalang.docgen.generator.model.UnionType;
import org.ballerinalang.docgen.generator.model.Variable;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.DocumentableNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;

public class Generator {
    private static final String EMPTY_STRING = "";

    public static void generateModuleConstructs(Module module, BLangPackage balPackage) {
        for (BLangTypeDefinition typeDefinition : balPackage.getTypeDefinitions()) {
            if (!typeDefinition.getFlags().contains(Flag.PUBLIC)) continue;
            Generator.createTypeDefModels(typeDefinition, module);
        }
        for (BLangFunction function : balPackage.getFunctions()) {
            if (!function.getFlags().contains(Flag.PUBLIC) || function.getFlags().contains(Flag.ATTACHED)) continue;
            module.functions.add(Generator.createDocForFunction(function, module));
        }
        for (BLangAnnotation annotation : balPackage.getAnnotations()) {
            if (!annotation.getFlags().contains(Flag.PUBLIC)) continue;
            module.annotations.add(Generator.createDocForAnnotation(annotation, module));
        }
        for (BLangConstant constant : balPackage.getConstants()) {
            if (!constant.getFlags().contains(Flag.PUBLIC)) continue;
            module.constants.add(Generator.createDocForConstant(constant, module));
        }
    }

    public static void createTypeDefModels(BLangTypeDefinition typeDefinition, Module module) {
        String typeName = typeDefinition.getName().getValue();
        boolean isDeprecated = Generator.isDeprecated(typeDefinition.getAnnotationAttachments());
        BLangType typeNode = typeDefinition.typeNode;
        NodeKind kind = typeNode.getKind();
        boolean added = false;
        if (kind == NodeKind.OBJECT_TYPE) {
            BLangObjectTypeNode objectType = (BLangObjectTypeNode)typeNode;
            Generator.addDocForObjectType(objectType, typeDefinition, module);
            added = true;
        } else if (kind == NodeKind.FINITE_TYPE_NODE) {
            BLangFiniteTypeNode enumNode = (BLangFiniteTypeNode)typeNode;
            List<String> values = enumNode.getValueSet().stream().map(java.lang.Object::toString).collect(Collectors.toList());
            module.finiteTypes.add(new FiniteType(typeName, Generator.description((BLangNode)typeDefinition), isDeprecated, values));
            added = true;
        } else if (kind == NodeKind.RECORD_TYPE) {
            BLangRecordTypeNode recordNode = (BLangRecordTypeNode)typeNode;
            Generator.addDocForRecordType(typeDefinition, recordNode, module);
            added = true;
        } else if (kind == NodeKind.UNION_TYPE_NODE) {
            List memberTypeNodes = ((BLangUnionTypeNode)typeNode).memberTypeNodes;
            List<Type> memberTypes = memberTypeNodes.stream().map(type -> Type.fromTypeNode(type, module.id)).collect(Collectors.toList());
            module.unionTypes.add(new UnionType(typeName, Generator.description((BLangNode)typeDefinition), isDeprecated, memberTypes));
            added = true;
        } else if (kind == NodeKind.USER_DEFINED_TYPE) {
            BLangUserDefinedType userDefinedType = (BLangUserDefinedType)typeNode;
            module.unionTypes.add(new UnionType(typeName, Generator.description((BLangNode)typeDefinition), isDeprecated, Collections.singletonList(Type.fromTypeNode((BLangType)userDefinedType, module.id))));
            added = true;
        } else if (kind == NodeKind.VALUE_TYPE) {
            added = true;
        } else if (kind == NodeKind.TUPLE_TYPE_NODE) {
            added = true;
        } else if (kind == NodeKind.ERROR_TYPE) {
            BLangErrorType errorType = (BLangErrorType)typeNode;
            Type detailType = errorType.detailType != null ? Type.fromTypeNode(errorType.detailType, module.id) : null;
            module.errors.add(new Error(errorType.type.tsymbol.name.value, Generator.description((BLangNode)typeDefinition), isDeprecated, detailType));
            added = true;
        } else if (kind == NodeKind.FUNCTION_TYPE) {
            added = true;
        } else if (kind == NodeKind.BUILT_IN_REF_TYPE) {
            added = true;
        } else if (kind == NodeKind.CONSTRAINED_TYPE) {
            added = true;
        }
        if (!added) {
            throw new UnsupportedOperationException("Type def not supported for " + kind);
        }
    }

    public static Annotation createDocForAnnotation(BLangAnnotation annotationNode, Module module) {
        String annotationName = annotationNode.getName().getValue();
        String attachments = annotationNode.getAttachPoints().stream().map(attachPoint -> attachPoint.point.getValue()).collect(Collectors.joining(", "));
        Type dataType = annotationNode.typeNode != null ? Type.fromTypeNode(annotationNode.typeNode, module.id) : null;
        return new Annotation(annotationName, Generator.description((BLangNode)annotationNode), Generator.isDeprecated(annotationNode.getAnnotationAttachments()), dataType, attachments);
    }

    public static Constant createDocForConstant(BLangConstant constant, Module module) {
        String constantName = constant.getName().getValue();
        BLangConstantValue value = constant.symbol.value;
        String desc = Generator.description((BLangNode)constant);
        BLangType typeNode = constant.typeNode != null ? constant.typeNode : constant.associatedTypeDefinition.typeNode;
        return new Constant(constantName, desc, Generator.isDeprecated(constant.getAnnotationAttachments()), Type.fromTypeNode(typeNode, module.id), value.toString());
    }

    public static Function createDocForFunction(BLangFunction functionNode, Module module) {
        BLangType returnType;
        String dataType;
        SimpleVariableNode restParameter;
        DefaultableVariable variable;
        String functionName = functionNode.getName().value;
        ArrayList<DefaultableVariable> parameters = new ArrayList<DefaultableVariable>();
        ArrayList<Variable> returnParams = new ArrayList<Variable>();
        if (functionNode.getParameters().size() > 0) {
            for (BLangSimpleVariable param : functionNode.getParameters()) {
                variable = Generator.getVariable(functionNode, param, module);
                parameters.add(variable);
            }
        }
        if (functionNode.getRestParameters() != null && (restParameter = functionNode.getRestParameters()) instanceof BLangSimpleVariable) {
            BLangSimpleVariable param;
            param = (BLangSimpleVariable)restParameter;
            variable = Generator.getVariable(functionNode, param, module);
            parameters.add(variable);
        }
        if (functionNode.getReturnTypeNode() != null && !(dataType = Generator.getTypeName(returnType = functionNode.getReturnTypeNode())).equals("null")) {
            String desc = Generator.returnParamAnnotation((BLangNode)functionNode);
            Variable variable2 = new Variable(EMPTY_STRING, desc, false, Type.fromTypeNode(returnType, module.id));
            returnParams.add(variable2);
        }
        return new Function(functionName, Generator.description((BLangNode)functionNode), functionNode.getFlags().contains(Flag.REMOTE), functionNode.getFlags().contains(Flag.NATIVE), Generator.isDeprecated(functionNode.getAnnotationAttachments()), parameters, returnParams);
    }

    private static DefaultableVariable getVariable(BLangFunction functionNode, BLangSimpleVariable param, Module mod) {
        String desc = Generator.paramAnnotation((BLangNode)functionNode, param);
        String defaultValue = EMPTY_STRING;
        if (null != param.getInitialExpression()) {
            defaultValue = param.getInitialExpression().toString();
        }
        return new DefaultableVariable(param.getName().value, desc, Generator.isDeprecated(param.getAnnotationAttachments()), Type.fromTypeNode(param.typeNode, mod.id), defaultValue);
    }

    private static void addDocForRecordType(BLangTypeDefinition typeDefinition, BLangRecordTypeNode recordType, Module module) {
        String recordName = typeDefinition.getName().getValue();
        if (recordType.isAnonymous) {
            recordName = "T" + recordName.substring(recordName.lastIndexOf(36) + 1);
        }
        BLangMarkdownDocumentation documentationNode = typeDefinition.getMarkdownDocumentationAttachment();
        List<DefaultableVariable> fields = Generator.getFields((BLangNode)recordType, recordType.fields, documentationNode, module);
        module.records.add(new Record(recordName, Generator.description((BLangNode)typeDefinition), Generator.isDeprecated(typeDefinition.getAnnotationAttachments()), recordType.isAnonymous, fields));
    }

    private static List<DefaultableVariable> getFields(BLangNode node, List<BLangSimpleVariable> allFields, BLangMarkdownDocumentation documentation, Module module) {
        ArrayList<DefaultableVariable> fields = new ArrayList<DefaultableVariable>();
        for (BLangSimpleVariable param : allFields) {
            if (!param.getFlags().contains(Flag.PUBLIC)) continue;
            String name = param.getName().value;
            String desc = Generator.findDescFromList(name, documentation, param);
            desc = desc.isEmpty() ? Generator.fieldAnnotation(node, (BLangNode)param) : desc;
            String defaultValue = EMPTY_STRING;
            if (null != param.getInitialExpression()) {
                defaultValue = param.getInitialExpression() instanceof BLangTypeInit ? (null == ((BLangTypeInit)param.getInitialExpression()).getType() ? ((BLangTypeInit)param.getInitialExpression()).expectedType.tsymbol.name.toString() : ((BLangTypeInit)param.getInitialExpression()).getType().toString()) : param.getInitialExpression().toString();
            }
            DefaultableVariable field = new DefaultableVariable(name, desc, Generator.isDeprecated(param.getAnnotationAttachments()), Type.fromTypeNode(param.typeNode, param.type, module.id), defaultValue);
            fields.add(field);
        }
        return fields;
    }

    private static String findDescFromList(String name, BLangMarkdownDocumentation documentation, BLangSimpleVariable param) {
        if (documentation == null) {
            return EMPTY_STRING;
        }
        Map parameterDocumentations = documentation.getParameterDocumentations();
        BLangMarkdownDocumentation paramDocAttach = param.getMarkdownDocumentationAttachment();
        if (paramDocAttach != null) {
            return BallerinaDocUtils.mdToHtml(paramDocAttach.getDocumentation());
        }
        BLangMarkdownParameterDocumentation parameter = (BLangMarkdownParameterDocumentation)parameterDocumentations.get(name);
        if (parameter != null) {
            return BallerinaDocUtils.mdToHtml(parameter.getParameterDocumentation());
        }
        return EMPTY_STRING;
    }

    private static void addDocForObjectType(BLangObjectTypeNode objectType, BLangTypeDefinition parent, Module module) {
        ArrayList<Function> functions = new ArrayList<Function>();
        String name = parent.getName().getValue();
        if (name != null && name.contains("$anonType$")) {
            name = "T" + name.substring(name.lastIndexOf(36) + 1);
        }
        String description = Generator.description((BLangNode)parent);
        boolean isDeprecated = Generator.isDeprecated(parent.getAnnotationAttachments());
        List<DefaultableVariable> fields = Generator.getFields((BLangNode)parent, objectType.fields, parent.getMarkdownDocumentationAttachment(), module);
        if (objectType.initFunction != null) {
            BLangFunction constructor = objectType.initFunction;
            if (constructor.flagSet.contains(Flag.PUBLIC)) {
                Function initFunction = Generator.createDocForFunction(constructor, module);
                if (initFunction.parameters.size() > 0) {
                    functions.add(initFunction);
                }
            }
        }
        if (objectType.getFunctions().size() > 0) {
            for (BLangFunction function : objectType.getFunctions()) {
                if (!function.flagSet.contains(Flag.PUBLIC)) continue;
                functions.add(Generator.createDocForFunction(function, module));
            }
        }
        if (Generator.isEndpoint(objectType)) {
            module.clients.add(new Client(name, description, isDeprecated, fields, functions));
        } else if (Generator.isListener(objectType)) {
            module.listeners.add(new Listener(name, description, isDeprecated, fields, functions));
        } else {
            module.objects.add(new Object(name, description, Generator.isDeprecated(parent.getAnnotationAttachments()), fields, functions));
        }
    }

    private static boolean isListener(BLangObjectTypeNode objectType) {
        AtomicBoolean isListener = new AtomicBoolean(false);
        objectType.typeRefs.forEach(type -> isListener.set(type instanceof BLangUserDefinedType && ((BLangUserDefinedType)type).typeName.value.equals("Listener")));
        return isListener.get();
    }

    private static boolean isEndpoint(BLangObjectTypeNode objectType) {
        return objectType.flagSet.contains(Flag.CLIENT);
    }

    private static String getTypeName(BLangType bLangType) {
        return bLangType instanceof BLangUserDefinedType ? ((BLangUserDefinedType)bLangType).typeName.value : bLangType.toString();
    }

    private static String paramAnnotation(BLangNode node, BLangSimpleVariable param) {
        String subName = param.getName() == null ? param.type.tsymbol.name.value : param.getName().getValue();
        return Generator.getParameterDocumentation(node, subName);
    }

    private static String returnParamAnnotation(BLangNode node) {
        if (!Generator.isDocumentAttached(node)) {
            return EMPTY_STRING;
        }
        BLangMarkdownDocumentation documentationAttachment = ((DocumentableNode)node).getMarkdownDocumentationAttachment();
        return BallerinaDocUtils.mdToHtml(documentationAttachment.getReturnParameterDocumentation());
    }

    private static String fieldAnnotation(BLangNode node, BLangNode param) {
        String subName = EMPTY_STRING;
        if (!(param instanceof BLangSimpleVariable)) {
            return Generator.getParameterDocumentation(node, subName);
        }
        BLangSimpleVariable paramVariable = (BLangSimpleVariable)param;
        subName = paramVariable.getName() == null ? paramVariable.type.tsymbol.name.value : paramVariable.getName().getValue();
        return Generator.getParameterDocumentation(node, subName);
    }

    private static String description(BLangNode node) {
        if (Generator.isDocumentAttached(node)) {
            BLangMarkdownDocumentation documentationAttachment = ((DocumentableNode)node).getMarkdownDocumentationAttachment();
            if (((DocumentableNode)node).getMarkdownDocumentationAttachment().deprecationDocumentation != null) {
                return Generator.replaceParagraphTag(BallerinaDocUtils.mdToHtml(documentationAttachment.getDocumentation()));
            }
            return BallerinaDocUtils.mdToHtml(documentationAttachment.getDocumentation());
        }
        return EMPTY_STRING;
    }

    private static String getParameterDocumentation(BLangNode node, String subName) {
        if (!Generator.isDocumentAttached(node)) {
            return EMPTY_STRING;
        }
        BLangMarkdownDocumentation documentationAttachment = ((DocumentableNode)node).getMarkdownDocumentationAttachment();
        Map parameterDocumentations = documentationAttachment.getParameterDocumentations();
        if (parameterDocumentations == null || parameterDocumentations.isEmpty()) {
            return EMPTY_STRING;
        }
        BLangMarkdownParameterDocumentation documentation = (BLangMarkdownParameterDocumentation)parameterDocumentations.get(subName);
        if (documentation != null) {
            return BallerinaDocUtils.mdToHtml(documentation.getParameterDocumentation());
        }
        return EMPTY_STRING;
    }

    private static boolean isDocumentAttached(BLangNode node) {
        return node instanceof DocumentableNode && ((DocumentableNode)node).getMarkdownDocumentationAttachment() != null;
    }

    private static boolean isDeprecated(List<BLangAnnotationAttachment> annotationAttachments) {
        if (annotationAttachments != null) {
            for (BLangAnnotationAttachment attachment : annotationAttachments) {
                if (!attachment.getAnnotationName().getValue().equals("deprecated")) continue;
                return true;
            }
        }
        return false;
    }

    private static String replaceParagraphTag(String documentation) {
        return documentation.replaceFirst("<p>", EMPTY_STRING).replaceFirst("</p>", EMPTY_STRING);
    }
}

