/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.generator.model;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.docgen.docs.BallerinaDocDataHolder;
import org.ballerinalang.model.elements.Flag;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;

public class Type {
    @Expose
    public String orgName;
    @Expose
    public String moduleName;
    @Expose
    public String name;
    @Expose
    public String description;
    @Expose
    public String category;
    @Expose
    public boolean isAnonymousUnionType;
    @Expose
    public boolean isArrayType;
    @Expose
    public boolean isNullable;
    @Expose
    public boolean isTuple;
    @Expose
    public boolean isLambda;
    @Expose
    public boolean isDeprecated;
    @Expose
    public boolean generateUserDefinedTypeLink = true;
    @Expose
    public List<Type> memberTypes = new ArrayList<Type>();
    @Expose
    public List<Type> paramTypes = new ArrayList<Type>();
    @Expose
    public int arrayDimensions;
    @Expose
    public Type elementType;
    @Expose
    public Type returnType;

    private Type() {
    }

    public Type(BType type) {
        this.name = type.tsymbol.name != null ? type.tsymbol.name.value : null;
        this.orgName = type.tsymbol.pkgID.orgName.value;
        this.moduleName = type.tsymbol.pkgID.name.value;
        this.setCategory(type);
    }

    public Type(BLangType type, String currentModule) {
        BTypeSymbol typeSymbol = type.type.tsymbol;
        if (typeSymbol != null && !typeSymbol.name.value.equals("")) {
            if (type instanceof BLangUserDefinedType) {
                BLangUserDefinedType userDefinedType = (BLangUserDefinedType)type;
                this.name = userDefinedType.typeName.value;
            } else {
                this.name = typeSymbol.name.value;
            }
            this.orgName = typeSymbol.pkgID.orgName.value;
            this.moduleName = typeSymbol.pkgID.name.value;
        } else if (type.type instanceof BUnionType) {
            if (type instanceof BLangUserDefinedType) {
                BLangUserDefinedType userDefinedType = (BLangUserDefinedType)type;
                this.name = userDefinedType.typeName.value;
                if (userDefinedType.pkgAlias.value.equals("")) {
                    this.orgName = BallerinaDocDataHolder.getInstance().getOrgName();
                    this.moduleName = ".";
                } else {
                    this.moduleName = userDefinedType.pkgAlias.value;
                }
            } else if (type instanceof BLangUnionTypeNode) {
                this.isAnonymousUnionType = true;
                ((BLangUnionTypeNode)type).memberTypeNodes.forEach(memberType -> this.memberTypes.add(Type.fromTypeNode(memberType, currentModule)));
                if (typeSymbol != null) {
                    this.orgName = typeSymbol.pkgID.orgName.value;
                    this.moduleName = typeSymbol.pkgID.name.value;
                }
            } else {
                this.name = type.type.toString();
            }
        }
        this.setCategory(type.type);
    }

    public Type(String name, String description, boolean isDeprecated) {
        this.name = name;
        this.description = description;
        this.isDeprecated = isDeprecated;
    }

    public static Type fromTypeNode(BLangType type, BType bType, String currentModule) {
        if (type == null) {
            return new Type(bType);
        }
        return Type.fromTypeNode(type, currentModule);
    }

    public static Type fromTypeNode(BLangType type, String currentModule) {
        Type typeModel = null;
        if (type instanceof BLangFunctionTypeNode) {
            typeModel = new Type();
            typeModel.isLambda = true;
            typeModel.paramTypes = ((BLangFunctionTypeNode)type).params.stream().map(p -> Type.fromTypeNode(p.typeNode, currentModule)).collect(Collectors.toList());
            typeModel.returnType = Type.fromTypeNode(((BLangFunctionTypeNode)type).returnTypeNode, currentModule);
        } else if (type instanceof BLangFiniteTypeNode) {
            List valueSpace = ((BLangFiniteTypeNode)type).valueSpace;
            if (valueSpace.size() == 1) {
                typeModel = new Type(((BLangExpression)valueSpace.get((int)0)).type);
            }
        } else if (type instanceof BLangArrayType) {
            BLangType elemtype = ((BLangArrayType)type).elemtype;
            String moduleName = elemtype.type.tsymbol == null ? type.type.tsymbol.pkgID.name.toString() : elemtype.type.tsymbol.pkgID.name.toString();
            Type elementType = Type.fromTypeNode(elemtype, moduleName);
            typeModel = new Type(type, currentModule);
            typeModel.elementType = elementType;
            typeModel.arrayDimensions = ((BLangArrayType)type).dimensions;
            typeModel.isArrayType = true;
            if (moduleName.equals(currentModule) && elemtype instanceof BLangUserDefinedType && !((BLangUserDefinedType)elemtype).flagSet.contains(Flag.PUBLIC)) {
                typeModel.generateUserDefinedTypeLink = false;
            }
        } else if (type instanceof BLangTupleTypeNode) {
            List memberTypeNodes = ((BLangTupleTypeNode)type).memberTypeNodes;
            typeModel = new Type(type, currentModule);
            typeModel.isTuple = true;
            typeModel.memberTypes = memberTypeNodes.stream().map(typeVal -> Type.fromTypeNode(typeVal, currentModule)).collect(Collectors.toList());
        } else if (type.nullable && type instanceof BLangUnionTypeNode && ((BLangUnionTypeNode)type).getMemberTypeNodes().size() == 2) {
            BLangUnionTypeNode unionType = (BLangUnionTypeNode)type;
            typeModel = Type.fromTypeNode((BLangType)unionType.getMemberTypeNodes().toArray()[0], currentModule);
        }
        if (typeModel == null) {
            typeModel = new Type(type, currentModule);
            if (type.type.tsymbol != null && type.type.tsymbol.pkgID.name.toString().equals(currentModule) && type instanceof BLangUserDefinedType && (type.type.tsymbol.flags & 1) != 1) {
                typeModel.generateUserDefinedTypeLink = false;
            }
        }
        typeModel.isNullable = type.nullable;
        if (type.type instanceof BNilType) {
            typeModel.name = "()";
        }
        if (typeModel.name != null && typeModel.name.contains("$anonType$")) {
            typeModel.name = "T" + typeModel.name.substring(typeModel.name.lastIndexOf(36) + 1);
        }
        return typeModel;
    }

    private void setCategory(BType type) {
        if (type.getClass().equals(BObjectType.class)) {
            BObjectTypeSymbol objSymbol = (BObjectTypeSymbol)type.tsymbol;
            this.category = objSymbol.getFlags().contains(Flag.CLIENT) ? "clients" : (objSymbol.getFlags().contains(Flag.LISTENER) || Type.isListenerObject((BSymbol)objSymbol) ? "listeners" : "objects");
        } else {
            switch (type.tag) {
                case 26: {
                    this.category = "annotations";
                    break;
                }
                case 12: {
                    this.category = "records";
                    break;
                }
                case 20: 
                case 32: {
                    Set valueSpace;
                    if (type instanceof BFiniteType && (valueSpace = ((BFiniteType)type).getValueSpace()).size() == 1 && valueSpace.toArray()[0] instanceof BLangLiteral) {
                        BLangLiteral literal = (BLangLiteral)valueSpace.toArray()[0];
                        if (literal.isConstant) {
                            this.category = "constants";
                            break;
                        }
                    }
                    this.category = "types";
                    break;
                }
                case 28: {
                    this.category = "errors";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 15: 
                case 17: 
                case 25: 
                case 31: 
                case 36: {
                    this.category = "builtin";
                    break;
                }
                default: {
                    this.category = "UNKNOWN";
                }
            }
        }
    }

    private static boolean isListenerObject(BSymbol bSymbol) {
        if (!(bSymbol instanceof BObjectTypeSymbol)) {
            return false;
        }
        List attachedFunctions = ((BObjectTypeSymbol)bSymbol).attachedFuncs.stream().map(function -> function.funcName.getValue()).collect(Collectors.toList());
        return attachedFunctions.contains("__start") && attachedFunctions.contains("__immediateStop") && attachedFunctions.contains("__attach");
    }
}

