/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.formatter.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.formatter.cli.Messages;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

class FormatUtil {
    static final String CMD_NAME = "format";
    private static final PrintStream outStream = System.err;
    private static EmptyPrintStream emptyPrintStream;

    FormatUtil() {
    }

    static void execute(List<String> argList, boolean helpFlag, boolean dryRun, Path sourceRootPath) {
        if (helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)CMD_NAME);
            outStream.println(commandUsageInfo);
            return;
        }
        if (argList != null && argList.size() > 1) {
            throw LauncherUtils.createLauncherException((String)Messages.getArgumentError());
        }
        try {
            if (argList != null && !argList.isEmpty()) {
                if (FormatUtil.isBalFile(argList.get(0))) {
                    String formattedSourceCode;
                    String ballerinaFilePath = argList.get(0);
                    Path filePath = Paths.get(ballerinaFilePath, new String[0]);
                    if (!filePath.toFile().exists() || filePath.toFile().isDirectory()) {
                        throw LauncherUtils.createLauncherException((String)Messages.getNoBallerinaFile(ballerinaFilePath));
                    }
                    String source = new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8);
                    if (FormatUtil.areChangesAvailable(source, formattedSourceCode = Formatter.format((String)source))) {
                        if (!dryRun) {
                            FormatUtil.writeFile(filePath.toAbsolutePath().toString(), formattedSourceCode);
                            outStream.println(Messages.getModifiedFiles() + System.lineSeparator() + ballerinaFilePath);
                            outStream.println(System.lineSeparator() + Messages.getSuccessMessage());
                        } else {
                            outStream.println(Messages.getFilesToModify() + System.lineSeparator() + ballerinaFilePath);
                        }
                    } else {
                        outStream.println(Messages.getNoChanges());
                    }
                } else {
                    if (Paths.get(argList.get(0), new String[0]).toFile().isFile()) {
                        throw LauncherUtils.createLauncherException((String)Messages.getNotABallerinaFile());
                    }
                    String moduleName = argList.get(0);
                    if (!FormatUtil.isModuleExist(moduleName, sourceRootPath)) {
                        if (moduleName.contains(".")) {
                            throw LauncherUtils.createLauncherException((String)Messages.getNoBallerinaModuleOrFile(moduleName));
                        }
                        throw LauncherUtils.createLauncherException((String)Messages.getNoModuleFound(moduleName));
                    }
                    if (!FormatUtil.isBallerinaProject(sourceRootPath)) {
                        throw LauncherUtils.createLauncherException((String)Messages.getNotBallerinaProject());
                    }
                    BLangPackage bLangPackage = FormatUtil.compileModule(sourceRootPath, FormatUtil.getModuleName(moduleName));
                    List<String> formattedFiles = FormatUtil.iterateAndFormat(bLangPackage, sourceRootPath, dryRun);
                    FormatUtil.generateChangeReport(formattedFiles, dryRun);
                }
            } else {
                List<BLangPackage> packages = FormatUtil.compileProject(sourceRootPath);
                ArrayList<String> formattedFiles = new ArrayList<String>();
                for (BLangPackage bLangPackage : packages) {
                    formattedFiles.addAll(FormatUtil.iterateAndFormat(bLangPackage, sourceRootPath, dryRun));
                }
                FormatUtil.generateChangeReport(formattedFiles, dryRun);
            }
        }
        catch (IOException | NullPointerException e) {
            throw LauncherUtils.createLauncherException((String)(Messages.getException() + e));
        }
    }

    private static void generateChangeReport(List<String> formattedFiles, boolean dryRun) {
        if (!formattedFiles.isEmpty()) {
            StringBuilder fileList = new StringBuilder();
            if (dryRun) {
                fileList.append(Messages.getFilesToModify()).append(System.lineSeparator());
            } else {
                fileList.append(Messages.getModifiedFiles()).append(System.lineSeparator());
            }
            for (String file : formattedFiles) {
                fileList.append(file).append(System.lineSeparator());
            }
            outStream.println(fileList.toString());
            if (!dryRun) {
                outStream.println(Messages.getSuccessMessage());
            }
        } else {
            outStream.println(Messages.getNoChanges());
        }
    }

    private static String getModuleName(String moduleName) {
        String pattern = Pattern.quote(File.separator);
        String[] splitedTokens = moduleName.split(pattern);
        return splitedTokens[splitedTokens.length - 1];
    }

    private static List<BLangPackage> compileProject(Path sourceRoot) throws UnsupportedEncodingException {
        emptyPrintStream = new EmptyPrintStream();
        CompilerContext context = FormatUtil.getCompilerContext(sourceRoot);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.setOutStream((PrintStream)emptyPrintStream);
        return compiler.compilePackages(false);
    }

    private static BLangPackage compileModule(Path sourceRoot, String moduleName) throws UnsupportedEncodingException {
        emptyPrintStream = new EmptyPrintStream();
        CompilerContext context = FormatUtil.getCompilerContext(sourceRoot);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.setOutStream((PrintStream)emptyPrintStream);
        return compiler.compile(moduleName);
    }

    private static void formatAndWrite(BLangCompilationUnit compilationUnit, Path sourceRootPath, List<String> formattedFiles, boolean dryRun) throws IOException {
        String fileName = Paths.get(sourceRootPath.toString(), new String[0]).resolve("src").resolve(compilationUnit.getPosition().getSource().getPackageName()).resolve(compilationUnit.getPosition().getSource().getCompilationUnitName()).toString();
        String formattedSource = Formatter.format((String)new String(Files.readAllBytes(Paths.get(fileName, new String[0])), StandardCharsets.UTF_8));
        if (FormatUtil.areChangesAvailable(formattedSource, formattedSource)) {
            if (!dryRun) {
                FormatUtil.writeFile(fileName, formattedSource);
            }
            formattedFiles.add(fileName);
        }
    }

    private static List<String> iterateAndFormat(BLangPackage bLangPackage, Path sourceRootPath, boolean dryRun) throws IOException {
        ArrayList<String> formattedFiles = new ArrayList<String>();
        for (BLangCompilationUnit compilationUnit : bLangPackage.getCompilationUnits()) {
            FormatUtil.formatAndWrite(compilationUnit, sourceRootPath, formattedFiles, dryRun);
        }
        for (BLangTestablePackage testablePackage : bLangPackage.getTestablePkgs()) {
            for (BLangCompilationUnit compilationUnit : testablePackage.getCompilationUnits()) {
                FormatUtil.formatAndWrite(compilationUnit, sourceRootPath, formattedFiles, dryRun);
            }
        }
        return formattedFiles;
    }

    private static CompilerContext getCompilerContext(Path sourceRootPath) {
        CompilerPhase compilerPhase = CompilerPhase.DEFINE;
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootPath.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(false));
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.toString(false));
        options.put(CompilerOptionName.TEST_ENABLED, "true");
        options.put(CompilerOptionName.LOCK_ENABLED, Boolean.toString(false));
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(true));
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, Boolean.toString(true));
        options.put(CompilerOptionName.NEW_PARSER_ENABLED, Boolean.toString(false));
        return context;
    }

    private static boolean isModuleExist(String module, Path projectRoot) {
        Path modulePath = module.startsWith("src/") ? projectRoot.resolve(module) : projectRoot.resolve("src").resolve(module);
        return modulePath.toFile().isDirectory();
    }

    private static boolean isBallerinaProject(Path path) {
        Path cachePath = path.resolve("Ballerina.toml");
        return cachePath.toFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String filePath, String content) throws IOException {
        try (OutputStreamWriter fileWriter = null;){
            try (FileOutputStream fileStream = new FileOutputStream(new File(filePath));){
                fileWriter = new OutputStreamWriter((OutputStream)fileStream, StandardCharsets.UTF_8);
            }
            fileWriter.write(content);
        }
    }

    private static boolean areChangesAvailable(String originalSource, String formattedSource) {
        return !originalSource.equals(formattedSource);
    }

    private static boolean isBalFile(String fileName) {
        return fileName.endsWith(".bal");
    }

    static class EmptyPrintStream
    extends PrintStream {
        EmptyPrintStream() throws UnsupportedEncodingException {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, true, "UTF-8");
        }
    }
}

