/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.cmd;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.ballerinalang.langserver.launchers.stdio.Main;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import picocli.CommandLine;

@CommandLine.Command(name="start-language-server", description={"start Ballerina language server"})
public class LangServerStartCmd
implements BLauncherCmd {
    private static final String CMD_NAME = "start-language-server";
    private static final String BALLERINA_HOME = System.getProperty("ballerina.home");
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;

    public void execute() {
        try {
            System.setProperty("ballerina.home", BALLERINA_HOME);
            LogManager.getLogManager().reset();
            Logger globalLogger = Logger.getLogger("global");
            globalLogger.setLevel(Level.OFF);
            Main.startServer((InputStream)System.in, (OutputStream)System.out);
        }
        catch (Throwable e) {
            throw LauncherUtils.createLauncherException((String)"Could not start language server");
        }
    }

    public String getName() {
        return CMD_NAME;
    }

    public void printLongDesc(StringBuilder out) {
    }

    public void printUsage(StringBuilder out) {
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

