/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.ModuleID;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.Name;

public class BallerinaModuleID
implements ModuleID {
    private static final String ANON_ORG = "$anon";
    private PackageID moduleID;

    public BallerinaModuleID(PackageID moduleID) {
        this.moduleID = moduleID;
    }

    @Override
    public String orgName() {
        return this.moduleID.getOrgName().getValue();
    }

    @Override
    public String moduleName() {
        return this.moduleID.getNameComps().stream().map(Name::getValue).collect(Collectors.joining("."));
    }

    @Override
    public String version() {
        return this.moduleID.getPackageVersion().getValue();
    }

    @Override
    public String modulePrefix() {
        List<Name> nameComps = this.moduleID.getNameComps();
        return nameComps.get(nameComps.size() - 1).getValue();
    }

    public String toString() {
        if (ANON_ORG.equals(this.orgName())) {
            return ".";
        }
        return this.orgName() + "/" + this.moduleName() + ":" + this.version();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BallerinaModuleID target = (BallerinaModuleID)obj;
        return this.moduleID.equals(target.moduleID);
    }

    public int hashCode() {
        return this.moduleID.hashCode();
    }
}

