/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.impl.BallerinaModuleID;
import io.ballerina.compiler.api.impl.EnvironmentResolver;
import io.ballerina.compiler.api.impl.NodeFinder;
import io.ballerina.compiler.api.impl.PositionUtil;
import io.ballerina.compiler.api.impl.ReferenceFinder;
import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.SymbolFinder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaTypeReferenceTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class BallerinaSemanticModel
implements SemanticModel {
    private final BLangPackage bLangPackage;
    private final CompilerContext compilerContext;
    private final EnvironmentResolver envResolver;
    private final SymbolFactory symbolFactory;
    private final TypesFactory typesFactory;

    public BallerinaSemanticModel(BLangPackage bLangPackage, CompilerContext context) {
        this.compilerContext = context;
        this.bLangPackage = bLangPackage;
        SymbolTable symbolTable = SymbolTable.getInstance(context);
        SymbolEnv pkgEnv = symbolTable.pkgEnvMap.get(bLangPackage.symbol);
        this.envResolver = new EnvironmentResolver(pkgEnv);
        this.symbolFactory = SymbolFactory.getInstance(context);
        this.typesFactory = TypesFactory.getInstance(context);
    }

    @Override
    public List<Symbol> visibleSymbols(String fileName, LinePosition linePosition) {
        ArrayList<Symbol> compiledSymbols = new ArrayList<Symbol>();
        SymbolResolver symbolResolver = SymbolResolver.getInstance(this.compilerContext);
        BLangCompilationUnit compilationUnit = this.getCompilationUnit(fileName);
        Map<Name, List<Scope.ScopeEntry>> scopeSymbols = symbolResolver.getAllVisibleInScopeSymbols(this.envResolver.lookUp(compilationUnit, linePosition));
        BLangDiagnosticLocation cursorPos = new BLangDiagnosticLocation(compilationUnit.name, linePosition.line(), linePosition.line(), linePosition.offset(), linePosition.offset());
        for (Map.Entry<Name, List<Scope.ScopeEntry>> entry : scopeSymbols.entrySet()) {
            Name name = entry.getKey();
            List<Scope.ScopeEntry> scopeEntries = entry.getValue();
            for (Scope.ScopeEntry scopeEntry : scopeEntries) {
                BSymbol symbol = scopeEntry.symbol;
                if (!this.hasCursorPosPassedSymbolPos(symbol, cursorPos) && !this.isImportedSymbol(symbol)) continue;
                compiledSymbols.add(this.symbolFactory.getBCompiledSymbol(symbol, name.getValue()));
            }
        }
        return compiledSymbols;
    }

    @Override
    public Optional<Symbol> symbol(String fileName, LinePosition position) {
        SymbolFinder symbolFinder = new SymbolFinder();
        BLangCompilationUnit compilationUnit = this.getCompilationUnit(fileName);
        BSymbol symbolAtCursor = symbolFinder.lookup(compilationUnit, position);
        if (symbolAtCursor == null) {
            return Optional.empty();
        }
        if (this.isTypeSymbol(symbolAtCursor) && !PositionUtil.withinBlock(position, symbolAtCursor.pos)) {
            BallerinaModuleID moduleID = new BallerinaModuleID(symbolAtCursor.pkgID);
            return Optional.of(new BallerinaTypeReferenceTypeSymbol(this.compilerContext, moduleID, symbolAtCursor.type, symbolAtCursor.getName().getValue()));
        }
        return Optional.ofNullable(this.symbolFactory.getBCompiledSymbol(symbolAtCursor, symbolAtCursor.name.value));
    }

    @Override
    public List<Symbol> moduleLevelSymbols() {
        ArrayList<Symbol> compiledSymbols = new ArrayList<Symbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> e : this.bLangPackage.symbol.scope.entries.entrySet()) {
            Name key = e.getKey();
            Scope.ScopeEntry value = e.getValue();
            if (value.symbol.origin != SymbolOrigin.SOURCE) continue;
            compiledSymbols.add(this.symbolFactory.getBCompiledSymbol(value.symbol, key.value));
        }
        return compiledSymbols;
    }

    @Override
    public List<Location> references(Symbol symbol) {
        Location symbolLocation = symbol.location();
        if (symbolLocation == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        BLangNode node = new NodeFinder().lookupEnclosingContainer(this.bLangPackage, symbolLocation.lineRange());
        ReferenceFinder refFinder = new ReferenceFinder();
        return refFinder.findReferences(node, this.getInternalSymbol(symbol));
    }

    @Override
    public List<Location> references(String fileName, LinePosition position) {
        SymbolFinder symbolFinder = new SymbolFinder();
        BLangCompilationUnit compilationUnit = this.getCompilationUnit(fileName);
        BSymbol symbolAtCursor = symbolFinder.lookup(compilationUnit, position);
        if (symbolAtCursor == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        BLangNode node = new NodeFinder().lookupEnclosingContainer(this.bLangPackage, symbolAtCursor.pos.lineRange());
        ReferenceFinder refFinder = new ReferenceFinder();
        return refFinder.findReferences(node, symbolAtCursor);
    }

    @Override
    public Optional<TypeSymbol> type(String fileName, LineRange range) {
        NodeFinder nodeFinder = new NodeFinder();
        BLangCompilationUnit compilationUnit = this.getCompilationUnit(fileName);
        BLangNode node = nodeFinder.lookup(compilationUnit, range);
        if (node == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.typesFactory.getTypeDescriptor(node.type));
    }

    @Override
    public List<Diagnostic> diagnostics(LineRange range) {
        List<Diagnostic> allDiagnostics = this.bLangPackage.getDiagnostics();
        ArrayList<Diagnostic> filteredDiagnostics = new ArrayList<Diagnostic>();
        for (Diagnostic diagnostic : allDiagnostics) {
            LineRange lineRange = diagnostic.location().lineRange();
            if (!lineRange.filePath().equals(range.filePath()) || !this.withinRange(lineRange, range)) continue;
            filteredDiagnostics.add(diagnostic);
        }
        return filteredDiagnostics;
    }

    @Override
    public List<Diagnostic> diagnostics() {
        return this.bLangPackage.getDiagnostics();
    }

    private boolean hasCursorPosPassedSymbolPos(BSymbol symbol, Location cursorPos) {
        if (symbol.origin != SymbolOrigin.SOURCE) {
            return false;
        }
        if (symbol.owner.getKind() == org.ballerinalang.model.symbols.SymbolKind.PACKAGE || Symbols.isFlagOn(symbol.flags, 0x800000L)) {
            return true;
        }
        if (!this.bLangPackage.packageID.equals(symbol.pkgID)) {
            return false;
        }
        LinePosition cursorPosStartLine = cursorPos.lineRange().startLine();
        LinePosition symbolStartLine = symbol.pos.lineRange().startLine();
        if (cursorPosStartLine.line() < symbolStartLine.line()) {
            return false;
        }
        if (cursorPosStartLine.line() > symbolStartLine.line()) {
            return true;
        }
        return cursorPosStartLine.offset() > symbolStartLine.offset();
    }

    private boolean isImportedSymbol(BSymbol symbol) {
        return symbol.origin == SymbolOrigin.COMPILED_SOURCE && (Symbols.isFlagOn(symbol.flags, 1L) || symbol.getKind() == org.ballerinalang.model.symbols.SymbolKind.PACKAGE);
    }

    private BLangCompilationUnit getCompilationUnit(String srcFile) {
        return this.bLangPackage.compUnits.stream().filter(unit -> unit.name.equals(srcFile)).findFirst().get();
    }

    private boolean isTypeSymbol(BSymbol symbol) {
        return symbol instanceof BTypeSymbol && !Symbols.isTagOn(symbol, 4097) && !Symbols.isTagOn(symbol, 2);
    }

    private BSymbol getInternalSymbol(Symbol symbol) {
        if (symbol.kind() == SymbolKind.TYPE) {
            return ((AbstractTypeSymbol)symbol).getBType().tsymbol;
        }
        return ((BallerinaSymbol)symbol).getInternalSymbol();
    }

    private boolean withinRange(LineRange range, LineRange specifiedRange) {
        int startLine = range.startLine().line();
        int startOffset = range.startLine().offset();
        int specifiedStartLine = specifiedRange.startLine().line();
        int specifiedEndLine = specifiedRange.endLine().line();
        int specifiedStartOffset = specifiedRange.startLine().offset();
        int specifiedEndOffset = specifiedRange.endLine().offset();
        return startLine >= specifiedStartLine && startLine <= specifiedEndLine && startOffset >= specifiedStartOffset && startOffset <= specifiedEndOffset;
    }
}

