/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl;

import io.ballerina.compiler.api.impl.BaseVisitor;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.clauses.OrderKeyNode;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangRetrySpec;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeyTypeConstraint;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangCaptureBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangListBindingPattern;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchGuard;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableMultiKeyExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangRestMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangWildCardMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;

public class ReferenceFinder
extends BaseVisitor {
    private List<Location> referenceLocations;
    private BSymbol targetSymbol;

    public List<Location> findReferences(BLangNode node, BSymbol symbol) {
        this.referenceLocations = new ArrayList<Location>();
        this.targetSymbol = symbol;
        this.find(node);
        return this.referenceLocations;
    }

    void find(BLangNode node) {
        if (node == null) {
            return;
        }
        node.accept(this);
    }

    void find(List<? extends BLangNode> nodes) {
        for (BLangNode bLangNode : nodes) {
            this.find(bLangNode);
        }
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        this.find(pkgNode.imports);
        this.find(pkgNode.xmlnsList);
        this.find(pkgNode.constants);
        this.find(pkgNode.globalVars);
        this.find(pkgNode.services);
        this.find(pkgNode.annotations);
        this.find(pkgNode.typeDefinitions);
        this.find(pkgNode.classDefinitions);
        this.find(pkgNode.functions.stream().filter(f -> !f.flagSet.contains((Object)Flag.LAMBDA)).collect(Collectors.toList()));
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        this.addIfSameSymbol(importPkgNode.symbol, importPkgNode.alias.pos);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        this.find(xmlnsNode.namespaceURI);
        this.addIfSameSymbol(xmlnsNode.symbol, xmlnsNode.prefix.pos);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        this.find(funcNode.annAttachments);
        this.find(funcNode.requiredParams);
        this.find(funcNode.restParam);
        this.find(funcNode.returnTypeAnnAttachments);
        this.find(funcNode.returnTypeNode);
        this.find(funcNode.body);
        if (funcNode.symbol.origin != SymbolOrigin.VIRTUAL) {
            this.addIfSameSymbol(funcNode.symbol, funcNode.name.pos);
        }
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        for (BLangStatement stmt : blockFuncBody.stmts) {
            this.find(stmt);
        }
    }

    @Override
    public void visit(BLangExprFunctionBody exprFuncBody) {
        this.find(exprFuncBody.expr);
    }

    @Override
    public void visit(BLangExternalFunctionBody externFuncBody) {
        this.find(externFuncBody.annAttachments);
    }

    @Override
    public void visit(BLangService serviceNode) {
        this.find(serviceNode.annAttachments);
        this.find(serviceNode.resourceFunctions);
        this.addIfSameSymbol(serviceNode.symbol, serviceNode.pos);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        this.find(typeDefinition.typeNode);
        this.find(typeDefinition.annAttachments);
        this.addIfSameSymbol(typeDefinition.symbol, typeDefinition.name.pos);
    }

    @Override
    public void visit(BLangConstant constant) {
        this.find(constant.typeNode);
        this.find(constant.expr);
        this.addIfSameSymbol(constant.symbol, constant.name.pos);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        this.find(varNode.annAttachments);
        this.find(varNode.typeNode);
        this.find(varNode.expr);
        this.addIfSameSymbol(varNode.symbol, varNode.name.pos);
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        this.find(annotationNode.annAttachments);
        this.find(annotationNode.typeNode);
        this.addIfSameSymbol(annotationNode.symbol, annotationNode.name.pos);
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        this.find(annAttachmentNode.expr);
        this.addIfSameSymbol(annAttachmentNode.annotationSymbol, annAttachmentNode.annotationName.pos);
    }

    @Override
    public void visit(BLangTableKeySpecifier tableKeySpecifierNode) {
    }

    @Override
    public void visit(BLangTableKeyTypeConstraint tableKeyTypeConstraint) {
        this.find(tableKeyTypeConstraint.keyType);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        for (BLangStatement stmt : blockNode.stmts) {
            this.find(stmt);
        }
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmtNode) {
        this.find(lockStmtNode.body);
        this.find(lockStmtNode.onFailClause);
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
        this.find(unLockNode.body);
        this.find(unLockNode.onFailClause);
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        this.find(varDefNode.var);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        this.find(assignNode.expr);
        this.find(assignNode.varRef);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        this.find(compoundAssignNode.expr);
        this.find(compoundAssignNode.varRef);
    }

    @Override
    public void visit(BLangRetry retryNode) {
        this.find(retryNode.retrySpec);
        this.find(retryNode.retryBody);
        this.find(retryNode.onFailClause);
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        this.find(retryTransaction.retrySpec);
        this.find(retryTransaction.transaction);
    }

    @Override
    public void visit(BLangRetrySpec retrySpec) {
        this.find(retrySpec.argExprs);
        this.find(retrySpec.retryManagerType);
    }

    @Override
    public void visit(BLangReturn returnNode) {
        this.find(returnNode.expr);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.find(panicNode.expr);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.find(xmlnsStmtNode.xmlnsDecl);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.find(exprStmtNode.expr);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.find(ifNode.expr);
        this.find(ifNode.body);
        this.find(ifNode.elseStmt);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        this.find(queryAction.doClause);
        this.find(queryAction.queryClauseList);
    }

    @Override
    public void visit(BLangMatch matchNode) {
        this.find(matchNode.expr);
        this.find(matchNode.patternClauses);
        this.find(matchNode.onFailClause);
    }

    @Override
    public void visit(BLangMatchStatement matchStatementNode) {
        this.find(matchStatementNode.expr);
        this.find(matchStatementNode.matchClauses);
        this.find(matchStatementNode.onFailClause);
    }

    @Override
    public void visit(BLangMatchGuard matchGuard) {
        this.find(matchGuard.expr);
    }

    @Override
    public void visit(BLangConstPattern constMatchPattern) {
        this.find(constMatchPattern.expr);
        this.find(constMatchPattern.matchExpr);
    }

    @Override
    public void visit(BLangWildCardMatchPattern wildCardMatchPattern) {
        this.find(wildCardMatchPattern.matchExpr);
    }

    @Override
    public void visit(BLangVarBindingPatternMatchPattern varBindingPattern) {
        this.find(varBindingPattern.getBindingPattern());
        this.find(varBindingPattern.matchExpr);
    }

    @Override
    public void visit(BLangCaptureBindingPattern captureBindingPattern) {
        this.addIfSameSymbol(captureBindingPattern.symbol, captureBindingPattern.getIdentifier().getPosition());
    }

    @Override
    public void visit(BLangListBindingPattern listBindingPattern) {
        this.find(listBindingPattern.bindingPatterns);
    }

    @Override
    public void visit(BLangMatch.BLangMatchTypedBindingPatternClause patternClauseNode) {
        this.find(patternClauseNode.body);
        this.find(patternClauseNode.variable);
        this.find(patternClauseNode.matchExpr);
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.find((BLangNode)((Object)foreach.variableDefinitionNode));
        this.find(foreach.collection);
        this.find(foreach.body);
        this.find(foreach.onFailClause);
    }

    @Override
    public void visit(BLangDo doNode) {
        this.find(doNode.body);
        this.find(doNode.onFailClause);
    }

    @Override
    public void visit(BLangFail failNode) {
        this.find(failNode.expr);
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.find((BLangNode)((Object)fromClause.variableDefinitionNode));
        this.find(fromClause.collection);
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        this.find((BLangNode)((Object)joinClause.variableDefinitionNode));
        this.find((BLangOnClause)joinClause.onClause);
        this.find(joinClause.collection);
    }

    @Override
    public void visit(BLangLetClause letClause) {
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            this.find((BLangNode)((Object)letVariable.definitionNode));
        }
    }

    @Override
    public void visit(BLangOnClause onClause) {
        this.find(onClause.lhsExpr);
        this.find(onClause.rhsExpr);
    }

    @Override
    public void visit(BLangOrderKey orderKeyClause) {
        this.find(orderKeyClause.expression);
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        for (OrderKeyNode orderKeyNode : orderByClause.orderByKeyList) {
            this.find((BLangOrderKey)orderKeyNode);
        }
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.find(selectClause.expression);
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.find(whereClause.expression);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.find(doClause.body);
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        this.find((BLangNode)((Object)onFailClause.variableDefinitionNode));
        this.find(onFailClause.body);
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        this.find(onConflictClause.expression);
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        this.find(limitClause.expression);
    }

    @Override
    public void visit(BLangMatchClause matchClause) {
        this.find(matchClause.expr);
        this.find(matchClause.matchGuard);
        this.find(matchClause.blockStmt);
        this.find(matchClause.matchPatterns);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.find(whileNode.expr);
        this.find(whileNode.body);
        this.find(whileNode.onFailClause);
    }

    @Override
    public void visit(BLangLock lockNode) {
        this.find(lockNode.body);
        this.find(lockNode.onFailClause);
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.find(transactionNode.transactionBody);
        this.find(transactionNode.onFailClause);
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        this.find(stmt.expr);
        this.find(stmt.varRef);
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        this.find(stmt.expr);
        this.find(stmt.varRef);
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        this.find(stmt.expr);
        this.find(stmt.varRef);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.find(forkJoin.workers);
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        this.find(workerSendNode.expr);
        this.addIfSameSymbol(workerSendNode.workerSymbol, workerSendNode.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.addIfSameSymbol(workerReceiveNode.workerSymbol, workerReceiveNode.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        this.find(rollbackNode.expr);
    }

    @Override
    public void visit(BLangConstRef constRef) {
        if (!constRef.pkgAlias.value.isEmpty()) {
            this.addIfSameSymbol(constRef.symbol.owner, constRef.pkgAlias.pos);
        }
        this.addIfSameSymbol(constRef.symbol, constRef.variableName.pos);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            this.find((BLangNode)((Object)field));
        }
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        this.find(varRefExpr.expressions);
        this.find((BLangNode)((Object)varRefExpr.restParam));
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordRefField : varRefExpr.recordRefFields) {
            this.find(recordRefField.getBindingPattern());
        }
        this.find((BLangNode)((Object)varRefExpr.restParam));
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.find(varRefExpr.typeNode);
        this.find(varRefExpr.message);
        this.find(varRefExpr.detail);
        this.find(varRefExpr.cause);
        this.find(varRefExpr.restVar);
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        if (varRefExpr.symbol == null) {
            return;
        }
        if (!varRefExpr.pkgAlias.value.isEmpty()) {
            this.addIfSameSymbol(varRefExpr.symbol.owner, varRefExpr.pkgAlias.pos);
        }
        this.addIfSameSymbol(varRefExpr.symbol, varRefExpr.pos);
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        this.find(fieldAccessExpr.expr);
        if (fieldAccessExpr instanceof BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess) {
            BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess nsPrefixedFieldBasedAccess = (BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)fieldAccessExpr;
            this.addIfSameSymbol(nsPrefixedFieldBasedAccess.nsSymbol, nsPrefixedFieldBasedAccess.nsPrefix.pos);
        } else {
            this.addIfSameSymbol(fieldAccessExpr.symbol, fieldAccessExpr.field.pos);
        }
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.find(indexAccessExpr.indexExpr);
        this.find(indexAccessExpr.expr);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        if (!invocationExpr.langLibInvocation) {
            this.find(invocationExpr.expr);
        }
        this.find(invocationExpr.requiredArgs);
        this.find(invocationExpr.annAttachments);
        this.find(invocationExpr.restArgs);
        if (!invocationExpr.pkgAlias.value.isEmpty()) {
            this.addIfSameSymbol(invocationExpr.symbol.owner, invocationExpr.pkgAlias.pos);
        }
        this.addIfSameSymbol(invocationExpr.symbol, invocationExpr.name.pos);
    }

    @Override
    public void visit(BLangTypeInit typeInit) {
        this.find(typeInit.userDefinedType);
        this.find(typeInit.argsExpr);
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocationExpr) {
        this.find(actionInvocationExpr.expr);
        this.find(actionInvocationExpr.requiredArgs);
        this.find(actionInvocationExpr.annAttachments);
        this.find(actionInvocationExpr.restArgs);
        if (!actionInvocationExpr.pkgAlias.value.isEmpty()) {
            this.addIfSameSymbol(actionInvocationExpr.symbol.owner, actionInvocationExpr.pkgAlias.pos);
        }
        this.addIfSameSymbol(actionInvocationExpr.symbol, actionInvocationExpr.name.pos);
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        this.find(ternaryExpr.expr);
        this.find(ternaryExpr.thenExpr);
        this.find(ternaryExpr.elseExpr);
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        this.find(waitExpr.exprList);
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.find(trapExpr.expr);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        this.find(binaryExpr.lhsExpr);
        this.find(binaryExpr.rhsExpr);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.find(elvisExpr.lhsExpr);
        this.find(elvisExpr.rhsExpr);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.find(groupExpr.expression);
    }

    @Override
    public void visit(BLangLetExpression letExpr) {
        for (BLangLetVariable letVarDeclaration : letExpr.letVarDeclarations) {
            this.find((BLangNode)((Object)letVarDeclaration.definitionNode));
        }
        this.find(letExpr.expr);
    }

    @Override
    public void visit(BLangLetVariable letVariable) {
        this.find((BLangNode)((Object)letVariable.definitionNode));
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        this.find(listConstructorExpr.exprs);
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.find(tableConstructorExpr.recordLiteralList);
        this.find(tableConstructorExpr.tableKeySpecifier);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.find(unaryExpr.expr);
    }

    @Override
    public void visit(BLangTypedescExpr typedescExpr) {
        this.find(typedescExpr.typeNode);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.find(conversionExpr.annAttachments);
        this.find(conversionExpr.typeNode);
        this.find(conversionExpr.expr);
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        this.addIfSameSymbol(xmlQName.nsSymbol, xmlQName.prefix.pos);
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        this.find(xmlAttribute.name);
        this.find(xmlAttribute.value);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        this.find(xmlElementLiteral.startTagName);
        this.find(xmlElementLiteral.endTagName);
        this.find(xmlElementLiteral.children);
        this.find(xmlElementLiteral.attributes);
        this.find(xmlElementLiteral.inlineNamespaces);
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        this.find(xmlTextLiteral.textFragments);
        this.find(xmlTextLiteral.concatExpr);
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        this.find(xmlCommentLiteral.textFragments);
        this.find(xmlCommentLiteral.concatExpr);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        this.find(xmlProcInsLiteral.target);
        this.find(xmlProcInsLiteral.dataFragments);
        this.find(xmlProcInsLiteral.dataConcatExpr);
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        this.find(xmlQuotedString.textFragments);
        this.find(xmlQuotedString.concatExpr);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.find(stringTemplateLiteral.exprs);
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        this.find(rawTemplateLiteral.insertions);
        this.find(rawTemplateLiteral.strings);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        this.find(bLangLambdaFunction.function);
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        this.find(bLangArrowFunction.params);
        this.find(bLangArrowFunction.body);
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        this.find(intRangeExpression.startExpr);
        this.find(intRangeExpression.endExpr);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.find(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.find(bLangNamedArgsExpression.expr);
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        this.find(assignableExpr.lhsExpr);
        this.find(assignableExpr.typeNode);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.find(checkedExpr.expr);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanickedExpr) {
        this.find(checkPanickedExpr.expr);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.find(serviceConstructorExpr.serviceNode);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.find(typeTestExpr.expr);
        this.find(typeTestExpr.typeNode);
    }

    @Override
    public void visit(BLangIsLikeExpr typeTestExpr) {
        this.find(typeTestExpr.expr);
        this.find(typeTestExpr.typeNode);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.addIfSameSymbol(annotAccessExpr.annotationSymbol, annotAccessExpr.annotationName.pos);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        this.find(queryExpr.queryClauseList);
    }

    @Override
    public void visit(BLangTableMultiKeyExpr tableMultiKeyExpr) {
        this.find(tableMultiKeyExpr.expr);
        this.find(tableMultiKeyExpr.multiKeyIndexExprs);
    }

    @Override
    public void visit(BLangObjectConstructorExpression objConstructor) {
        this.find(objConstructor.classNode);
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.find(arrayType.elemtype);
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.find(constrainedType.type);
        this.find(constrainedType.constraint);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.find(streamType.constraint);
        this.find(streamType.error);
    }

    @Override
    public void visit(BLangTableTypeNode tableType) {
        this.find(tableType.constraint);
        this.find(tableType.tableKeySpecifier);
        this.find(tableType.tableKeyTypeConstraint);
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        if (!userDefinedType.pkgAlias.value.isEmpty()) {
            this.addIfSameSymbol(userDefinedType.type.tsymbol.owner, userDefinedType.pkgAlias.pos);
        }
        this.addIfSameSymbol(userDefinedType.type.tsymbol, userDefinedType.typeName.pos);
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        this.find(functionTypeNode.params);
        this.find(functionTypeNode.restParam);
        this.find(functionTypeNode.returnTypeNode);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        this.find(unionTypeNode.memberTypeNodes);
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        this.find(intersectionTypeNode.constituentTypeNodes);
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        this.find(objectTypeNode.fields);
        this.find(objectTypeNode.functions);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        this.find(recordTypeNode.fields);
        this.find(recordTypeNode.restFieldType);
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        this.find(finiteTypeNode.valueSpace);
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        this.find(tupleTypeNode.memberTypeNodes);
        this.find(tupleTypeNode.restParamType);
    }

    @Override
    public void visit(BLangErrorType errorType) {
        this.find(errorType.detailType);
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
        this.find(bLangXMLSequenceLiteral.xmlItems);
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        this.find(bLangTupleVariable.annAttachments);
        this.find(bLangTupleVariable.memberVariables);
        this.find(bLangTupleVariable.restVariable);
        this.find(bLangTupleVariable.expr);
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.find(bLangTupleVariableDef.var);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        for (BLangRecordVariable.BLangRecordVariableKeyValue variableKeyValue : bLangRecordVariable.variableList) {
            this.find(variableKeyValue.valueBindingPattern);
        }
        this.find(bLangRecordVariable.annAttachments);
        this.find((BLangNode)((Object)bLangRecordVariable.restParam));
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.find(bLangRecordVariableDef.var);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        this.find(bLangErrorVariable.message);
        this.find(bLangErrorVariable.restDetail);
        this.find(bLangErrorVariable.cause);
        this.find(bLangErrorVariable.reasonMatchConst);
        for (BLangErrorVariable.BLangErrorDetailEntry errorDetailEntry : bLangErrorVariable.detail) {
            this.find(errorDetailEntry.valueBindingPattern);
        }
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.find(bLangErrorVariableDef.errorVariable);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause bLangMatchStmtStaticBindingPatternClause) {
        this.find(bLangMatchStmtStaticBindingPatternClause.body);
        this.find(bLangMatchStmtStaticBindingPatternClause.literal);
        this.find(bLangMatchStmtStaticBindingPatternClause.matchExpr);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause bLangMatchStmtStructuredBindingPatternClause) {
        this.find(bLangMatchStmtStructuredBindingPatternClause.body);
        this.find(bLangMatchStmtStructuredBindingPatternClause.bindingPatternVariable);
        this.find(bLangMatchStmtStructuredBindingPatternClause.matchExpr);
        this.find(bLangMatchStmtStructuredBindingPatternClause.typeGuardExpr);
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.addIfSameSymbol(workerFlushExpr.workerSymbol, workerFlushExpr.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        this.find(syncSendExpr.expr);
        this.addIfSameSymbol(syncSendExpr.workerSymbol, syncSendExpr.workerIdentifier.pos);
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        this.find(waitForAllExpr.keyValuePairs);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordKeyValueField recordKeyValue) {
        this.find(recordKeyValue.key);
        this.find(recordKeyValue.valueExpr);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordKey recordKey) {
        this.find(recordKey.expr);
        this.addIfSameSymbol(recordKey.fieldSymbol, recordKey.pos);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOperatorField) {
        this.find(spreadOperatorField.expr);
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitKeyValue waitKeyValue) {
        this.find(waitKeyValue.keyExpr);
        this.find(waitKeyValue.valueExpr);
    }

    @Override
    public void visit(BLangXMLElementFilter xmlElementFilter) {
        this.addIfSameSymbol(xmlElementFilter.namespaceSymbol, xmlElementFilter.nsPos);
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.find(xmlElementAccess.expr);
        this.find(xmlElementAccess.filters);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        this.find(xmlNavigation.childIndex);
        this.find(xmlNavigation.filters);
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        this.find(classDefinition.annAttachments);
        this.find(classDefinition.fields);
        this.find(classDefinition.initFunction);
        this.find(classDefinition.functions);
        this.addIfSameSymbol(classDefinition.symbol, classDefinition.name.pos);
    }

    @Override
    public void visit(BLangListMatchPattern listMatchPattern) {
        this.find(listMatchPattern.matchExpr);
        this.find(listMatchPattern.matchPatterns);
        this.find(listMatchPattern.restMatchPattern);
    }

    @Override
    public void visit(BLangRestMatchPattern restMatchPattern) {
        this.find(restMatchPattern.matchExpr);
        this.addIfSameSymbol(restMatchPattern.symbol, restMatchPattern.variableName.pos);
    }

    private void addIfSameSymbol(BSymbol symbol, Location location) {
        if (symbol != null && this.targetSymbol.name.equals(symbol.name) && this.targetSymbol.pkgID.equals(symbol.pkgID) && this.targetSymbol.pos.equals(symbol.pos)) {
            this.referenceLocations.add(location);
        }
    }
}

