/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.symbols.BallerinaDocumentation;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FieldSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaFieldSymbol
extends BallerinaSymbol
implements FieldSymbol {
    private final Documentation docAttachment;
    private final BField bField;
    private final CompilerContext context;
    private TypeSymbol typeDescriptor;

    public BallerinaFieldSymbol(CompilerContext context, BField bField) {
        super(bField.name.value, bField.symbol.pkgID, SymbolKind.FIELD, bField.symbol);
        this.context = context;
        this.bField = bField;
        this.docAttachment = new BallerinaDocumentation(bField.symbol.markdownDocumentation);
    }

    @Override
    public String name() {
        return this.bField.getName().getValue();
    }

    @Override
    public boolean isOptional() {
        return (this.bField.type.flags & 0x1000L) == 4096L;
    }

    @Override
    public boolean hasDefaultValue() {
        return !this.isOptional() && (this.bField.symbol.flags & 0x100L) != 256L;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        if (this.typeDescriptor == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.typeDescriptor = typesFactory.getTypeDescriptor(this.bField.type);
        }
        return this.typeDescriptor;
    }

    @Override
    public Optional<Documentation> documentation() {
        return Optional.ofNullable(this.docAttachment);
    }

    @Override
    public Optional<Qualifier> qualifier() {
        if ((this.bField.symbol.flags & 1L) == 1L) {
            return Optional.of(Qualifier.PUBLIC);
        }
        if ((this.bField.symbol.flags & 0x400L) == 1024L) {
            return Optional.of(Qualifier.PRIVATE);
        }
        return Optional.empty();
    }

    @Override
    public String signature() {
        StringBuilder signature = new StringBuilder(this.typeDescriptor().signature() + " " + this.name());
        if (this.isOptional()) {
            signature.append("?");
        }
        return signature.toString();
    }
}

