/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaClassSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaConstantSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ServiceSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class BallerinaModule
extends BallerinaSymbol
implements ModuleSymbol {
    private final CompilerContext context;
    private BPackageSymbol packageSymbol;
    private List<TypeDefinitionSymbol> typeDefs;
    private List<ClassSymbol> classes;
    private List<FunctionSymbol> functions;
    private List<ConstantSymbol> constants;
    private List<ObjectTypeSymbol> listeners;
    private List<Symbol> allSymbols;

    protected BallerinaModule(CompilerContext context, String name, PackageID moduleID, BPackageSymbol packageSymbol) {
        super(name, moduleID, SymbolKind.MODULE, packageSymbol);
        this.context = context;
        this.packageSymbol = packageSymbol;
    }

    @Override
    public List<FunctionSymbol> functions() {
        if (this.functions != null) {
            return this.functions;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<BallerinaFunctionSymbol> functions = new ArrayList<BallerinaFunctionSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> entry : this.packageSymbol.scope.entries.entrySet()) {
            Scope.ScopeEntry scopeEntry = entry.getValue();
            if (scopeEntry.symbol == null || scopeEntry.symbol.kind != org.ballerinalang.model.symbols.SymbolKind.FUNCTION || !Symbols.isFlagOn(scopeEntry.symbol.flags, 1L) || scopeEntry.symbol.origin != SymbolOrigin.COMPILED_SOURCE) continue;
            String funcName = scopeEntry.symbol.getName().getValue();
            functions.add(symbolFactory.createFunctionSymbol((BInvokableSymbol)scopeEntry.symbol, funcName));
        }
        this.functions = Collections.unmodifiableList(functions);
        return this.functions;
    }

    @Override
    public List<TypeDefinitionSymbol> typeDefinitions() {
        if (this.typeDefs == null) {
            this.typeDefs = this.allSymbols().stream().filter(symbol -> symbol.kind() == SymbolKind.TYPE).map(symbol -> (TypeDefinitionSymbol)symbol).collect(Collectors.toUnmodifiableList());
        }
        return this.typeDefs;
    }

    @Override
    public List<ClassSymbol> classes() {
        if (this.classes != null) {
            return this.classes;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<BallerinaClassSymbol> classes = new ArrayList<BallerinaClassSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> entry : this.packageSymbol.scope.entries.entrySet()) {
            Scope.ScopeEntry scopeEntry = entry.getValue();
            if (!(scopeEntry.symbol instanceof BClassSymbol) || (scopeEntry.symbol.flags & 1L) != 1L) continue;
            String constName = scopeEntry.symbol.getName().getValue();
            classes.add(symbolFactory.createClassSymbol((BClassSymbol)scopeEntry.symbol, constName));
        }
        this.classes = Collections.unmodifiableList(classes);
        return this.classes;
    }

    @Override
    public List<ConstantSymbol> constants() {
        if (this.constants != null) {
            return this.constants;
        }
        SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
        ArrayList<BallerinaConstantSymbol> constants = new ArrayList<BallerinaConstantSymbol>();
        for (Map.Entry<Name, Scope.ScopeEntry> entry : this.packageSymbol.scope.entries.entrySet()) {
            Scope.ScopeEntry scopeEntry = entry.getValue();
            if (!(scopeEntry.symbol instanceof BConstantSymbol) || (scopeEntry.symbol.flags & 1L) != 1L) continue;
            String constName = scopeEntry.symbol.getName().getValue();
            constants.add(symbolFactory.createConstantSymbol((BConstantSymbol)scopeEntry.symbol, constName));
        }
        this.constants = Collections.unmodifiableList(constants);
        return this.constants;
    }

    @Override
    public List<ObjectTypeSymbol> listeners() {
        if (this.listeners != null) {
            return this.listeners;
        }
        this.listeners = new ArrayList<ObjectTypeSymbol>();
        return this.listeners;
    }

    @Override
    public List<ServiceSymbol> services() {
        return new ArrayList<ServiceSymbol>();
    }

    @Override
    public List<Symbol> allSymbols() {
        if (this.allSymbols == null) {
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (Map.Entry<Name, Scope.ScopeEntry> entry : this.packageSymbol.scope.entries.entrySet()) {
                Scope.ScopeEntry scopeEntry = entry.getValue();
                if (!Symbols.isFlagOn(scopeEntry.symbol.flags, 1L) || scopeEntry.symbol.origin != SymbolOrigin.COMPILED_SOURCE && scopeEntry.symbol.origin != SymbolOrigin.SOURCE) continue;
                symbols.add(symbolFactory.getBCompiledSymbol(scopeEntry.symbol, scopeEntry.symbol.getName().getValue()));
            }
            this.allSymbols = Collections.unmodifiableList(symbols);
        }
        return this.allSymbols;
    }

    public static class ModuleSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<ModuleSymbolBuilder> {
        private final CompilerContext context;

        public ModuleSymbolBuilder(CompilerContext context, String name, PackageID moduleID, BPackageSymbol packageSymbol) {
            super(name, moduleID, SymbolKind.MODULE, packageSymbol);
            this.context = context;
        }

        @Override
        public BallerinaModule build() {
            if (this.bSymbol == null) {
                throw new AssertionError((Object)"Package Symbol cannot be null");
            }
            return new BallerinaModule(this.context, this.name, this.moduleID, (BPackageSymbol)this.bSymbol);
        }
    }
}

