/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.BallerinaFunctionSymbol;
import io.ballerina.compiler.api.impl.symbols.BallerinaSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ServiceSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaServiceSymbol
extends BallerinaSymbol
implements ServiceSymbol {
    private final BServiceSymbol serviceSymbol;
    private final CompilerContext context;
    private List<FunctionSymbol> resources;
    private List<FunctionSymbol> functions;

    private BallerinaServiceSymbol(CompilerContext context, String name, PackageID moduleID, BServiceSymbol serviceSymbol) {
        super(name, moduleID, SymbolKind.SERVICE, serviceSymbol);
        this.serviceSymbol = serviceSymbol;
        this.context = context;
    }

    @Override
    public List<FunctionSymbol> resources() {
        if (this.resources == null) {
            this.resources = this.getResources(this.serviceSymbol);
        }
        return this.resources;
    }

    @Override
    public List<FunctionSymbol> functions() {
        if (this.functions == null) {
            this.functions = this.getFunctions(this.serviceSymbol);
        }
        return this.functions;
    }

    private List<FunctionSymbol> getResources(BServiceSymbol serviceSymbol) {
        ArrayList<BallerinaFunctionSymbol> resources = new ArrayList<BallerinaFunctionSymbol>();
        if (serviceSymbol.type.tsymbol instanceof BObjectTypeSymbol) {
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            for (BAttachedFunction function : ((BObjectTypeSymbol)serviceSymbol.type.tsymbol).attachedFuncs) {
                if ((function.symbol.flags & 0x20000L) != 131072L) continue;
                String name = function.symbol.getName().getValue();
                BallerinaFunctionSymbol functionSymbol = symbolFactory.createFunctionSymbol(function.symbol, name);
                resources.add(functionSymbol);
            }
        }
        return Collections.unmodifiableList(resources);
    }

    private List<FunctionSymbol> getFunctions(BServiceSymbol serviceSymbol) {
        ArrayList<BallerinaFunctionSymbol> functions = new ArrayList<BallerinaFunctionSymbol>();
        if (serviceSymbol.type.tsymbol instanceof BObjectTypeSymbol) {
            SymbolFactory symbolFactory = SymbolFactory.getInstance(this.context);
            for (BAttachedFunction function : ((BObjectTypeSymbol)serviceSymbol.type.tsymbol).attachedFuncs) {
                if ((function.symbol.flags & 0x20000L) == 131072L) continue;
                String name = function.symbol.getName().getValue();
                BallerinaFunctionSymbol functionSymbol = symbolFactory.createFunctionSymbol(function.symbol, name);
                functions.add(functionSymbol);
            }
        }
        return Collections.unmodifiableList(functions);
    }

    public static class ServiceSymbolBuilder
    extends BallerinaSymbol.SymbolBuilder<ServiceSymbolBuilder> {
        private final CompilerContext context;

        public ServiceSymbolBuilder(CompilerContext context, String name, PackageID moduleID, BServiceSymbol serviceSymbol) {
            super(name, moduleID, SymbolKind.SERVICE, serviceSymbol);
            this.context = context;
        }

        @Override
        public BallerinaServiceSymbol build() {
            return new BallerinaServiceSymbol(this.context, this.name, this.moduleID, (BServiceSymbol)this.bSymbol);
        }
    }
}

