/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaStreamTypeSymbol
extends AbstractTypeSymbol
implements StreamTypeSymbol {
    private TypeSymbol typeParameter;
    private TypeSymbol completionValueTypeParameter;
    private String signature;

    public BallerinaStreamTypeSymbol(CompilerContext context, ModuleID moduleID, BStreamType streamType) {
        super(context, TypeDescKind.STREAM, moduleID, streamType);
    }

    @Override
    public TypeSymbol typeParameter() {
        if (this.typeParameter == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.typeParameter = typesFactory.getTypeDescriptor(((BStreamType)this.getBType()).constraint);
        }
        return this.typeParameter;
    }

    @Override
    public Optional<TypeSymbol> completionValueTypeParameter() {
        BType completionType;
        if (this.completionValueTypeParameter == null && (completionType = ((BStreamType)this.getBType()).error) != null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.completionValueTypeParameter = typesFactory.getTypeDescriptor(completionType);
        }
        return Optional.ofNullable(this.completionValueTypeParameter);
    }

    @Override
    public String signature() {
        if (this.signature == null) {
            StringBuilder sigBuilder = new StringBuilder("stream<");
            sigBuilder.append(this.typeParameter().signature());
            this.completionValueTypeParameter().ifPresent(t -> sigBuilder.append(", ").append(t.signature()));
            sigBuilder.append('>');
            this.signature = sigBuilder.toString();
        }
        return this.signature;
    }
}

