/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.symbols;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaTypeReferenceTypeSymbol
extends AbstractTypeSymbol
implements TypeReferenceTypeSymbol {
    private static final String ANON_ORG = "$anon";
    private final String definitionName;
    private TypeSymbol typeDescriptorImpl;
    private Location location;

    public BallerinaTypeReferenceTypeSymbol(CompilerContext context, ModuleID moduleID, BType bType, String definitionName) {
        super(context, TypeDescKind.TYPE_REFERENCE, moduleID, bType);
        this.definitionName = definitionName;
    }

    @Override
    public TypeSymbol typeDescriptor() {
        if (this.typeDescriptorImpl == null) {
            TypesFactory typesFactory = TypesFactory.getInstance(this.context);
            this.typeDescriptorImpl = typesFactory.getTypeDescriptor(this.getBType(), true);
        }
        return this.typeDescriptorImpl;
    }

    @Override
    public List<FunctionSymbol> langLibMethods() {
        return this.typeDescriptor().langLibMethods();
    }

    @Override
    public String name() {
        return this.definitionName;
    }

    @Override
    public Location location() {
        if (this.location == null) {
            BType type = this.getBType();
            if (type.tsymbol != null) {
                this.location = type.tsymbol.pos;
            }
        }
        return this.location;
    }

    @Override
    public String signature() {
        if (this.moduleID() == null || this.moduleID().moduleName().equals("lang.annotations") && this.moduleID().orgName().equals("ballerina")) {
            return this.definitionName;
        }
        return !this.isAnonOrg(this.moduleID()) ? this.moduleID().orgName() + Names.ORG_NAME_SEPARATOR + this.moduleID().moduleName() + Names.VERSION_SEPARATOR + this.moduleID().version() + ":" + this.definitionName : this.definitionName;
    }

    private boolean isAnonOrg(ModuleID moduleID) {
        return ANON_ORG.equals(moduleID.orgName());
    }
}

