/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.diagnostics;

import io.ballerina.compiler.internal.diagnostics.DiagnosticMessageHelper;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.DiagnosticInfo;

public class SyntaxDiagnostic
extends Diagnostic {
    private final STNodeDiagnostic nodeDiagnostic;
    private final NodeLocation location;
    private DiagnosticInfo diagnosticInfo;

    private SyntaxDiagnostic(STNodeDiagnostic nodeDiagnostic, NodeLocation location) {
        this.nodeDiagnostic = nodeDiagnostic;
        this.location = location;
    }

    public static SyntaxDiagnostic from(STNodeDiagnostic nodeDiagnostic, NodeLocation location) {
        return new SyntaxDiagnostic(nodeDiagnostic, location);
    }

    @Override
    public NodeLocation location() {
        return this.location;
    }

    @Override
    public DiagnosticInfo diagnosticInfo() {
        if (this.diagnosticInfo != null) {
            return this.diagnosticInfo;
        }
        DiagnosticCode diagnosticCode = this.nodeDiagnostic.diagnosticCode();
        this.diagnosticInfo = new DiagnosticInfo(diagnosticCode.diagnosticId(), diagnosticCode.toString(), diagnosticCode.severity());
        return this.diagnosticInfo;
    }

    @Override
    public String message() {
        return DiagnosticMessageHelper.getDiagnosticMessage(this.nodeDiagnostic.diagnosticCode(), this.nodeDiagnostic.args());
    }

    @Override
    public String toString() {
        return this.diagnosticInfo().severity().toString() + " [" + this.location().lineRange().filePath() + ":" + this.location().lineRange() + "] " + this.message();
    }
}

