/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.parser.AbstractLexer;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayList;
import java.util.List;

public class BallerinaLexer
extends AbstractLexer {
    public BallerinaLexer(CharReader charReader) {
        super(charReader, ParserMode.DEFAULT);
    }

    @Override
    public STToken nextToken() {
        STToken token;
        switch (this.mode) {
            case TEMPLATE: {
                token = this.readTemplateToken();
                break;
            }
            case INTERPOLATION: {
                this.processLeadingTrivia();
                token = this.readTokenInInterpolation();
                break;
            }
            case INTERPOLATION_BRACED_CONTENT: {
                this.processLeadingTrivia();
                token = this.readTokenInBracedContentInInterpolation();
                break;
            }
            default: {
                this.processLeadingTrivia();
                token = this.readToken();
            }
        }
        return this.cloneWithDiagnostics(token);
    }

    private STToken readToken() {
        STToken token;
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char c = this.reader.peek();
        this.reader.advance();
        switch (c) {
            case ':': {
                token = this.getSyntaxToken(SyntaxKind.COLON_TOKEN);
                break;
            }
            case ';': {
                token = this.getSyntaxToken(SyntaxKind.SEMICOLON_TOKEN);
                break;
            }
            case '.': {
                token = this.processDot();
                break;
            }
            case ',': {
                token = this.getSyntaxToken(SyntaxKind.COMMA_TOKEN);
                break;
            }
            case '(': {
                token = this.getSyntaxToken(SyntaxKind.OPEN_PAREN_TOKEN);
                break;
            }
            case ')': {
                token = this.getSyntaxToken(SyntaxKind.CLOSE_PAREN_TOKEN);
                break;
            }
            case '{': {
                if (this.peek() == 124) {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.OPEN_BRACE_PIPE_TOKEN);
                    break;
                }
                token = this.getSyntaxToken(SyntaxKind.OPEN_BRACE_TOKEN);
                break;
            }
            case '}': {
                token = this.getSyntaxToken(SyntaxKind.CLOSE_BRACE_TOKEN);
                break;
            }
            case '[': {
                token = this.getSyntaxToken(SyntaxKind.OPEN_BRACKET_TOKEN);
                break;
            }
            case ']': {
                token = this.getSyntaxToken(SyntaxKind.CLOSE_BRACKET_TOKEN);
                break;
            }
            case '|': {
                token = this.processPipeOperator();
                break;
            }
            case '?': {
                if (this.peek() == 46 && this.reader.peek(1) != '.') {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.OPTIONAL_CHAINING_TOKEN);
                    break;
                }
                if (this.peek() == 58) {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.ELVIS_TOKEN);
                    break;
                }
                token = this.getSyntaxToken(SyntaxKind.QUESTION_MARK_TOKEN);
                break;
            }
            case '\"': {
                token = this.processStringLiteral();
                break;
            }
            case '#': {
                token = this.processDocumentationString();
                break;
            }
            case '@': {
                token = this.getSyntaxToken(SyntaxKind.AT_TOKEN);
                break;
            }
            case '=': {
                token = this.processEqualOperator();
                break;
            }
            case '+': {
                token = this.getSyntaxToken(SyntaxKind.PLUS_TOKEN);
                break;
            }
            case '-': {
                if (this.reader.peek() == '>') {
                    this.reader.advance();
                    if (this.peek() == 62) {
                        this.reader.advance();
                        token = this.getSyntaxToken(SyntaxKind.SYNC_SEND_TOKEN);
                        break;
                    }
                    token = this.getSyntaxToken(SyntaxKind.RIGHT_ARROW_TOKEN);
                    break;
                }
                token = this.getSyntaxToken(SyntaxKind.MINUS_TOKEN);
                break;
            }
            case '*': {
                token = this.getSyntaxToken(SyntaxKind.ASTERISK_TOKEN);
                break;
            }
            case '/': {
                token = this.processSlashToken();
                break;
            }
            case '%': {
                token = this.getSyntaxToken(SyntaxKind.PERCENT_TOKEN);
                break;
            }
            case '<': {
                int nextChar = this.peek();
                if (nextChar == 61) {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.LT_EQUAL_TOKEN);
                    break;
                }
                if (nextChar == 45) {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.LEFT_ARROW_TOKEN);
                    break;
                }
                if (nextChar == 60) {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.DOUBLE_LT_TOKEN);
                    break;
                }
                token = this.getSyntaxToken(SyntaxKind.LT_TOKEN);
                break;
            }
            case '>': {
                token = this.processTokenStartWithGt();
                break;
            }
            case '!': {
                token = this.processExclamationMarkOperator();
                break;
            }
            case '&': {
                if (this.peek() == 38) {
                    this.reader.advance();
                    token = this.getSyntaxToken(SyntaxKind.LOGICAL_AND_TOKEN);
                    break;
                }
                token = this.getSyntaxToken(SyntaxKind.BITWISE_AND_TOKEN);
                break;
            }
            case '^': {
                token = this.getSyntaxToken(SyntaxKind.BITWISE_XOR_TOKEN);
                break;
            }
            case '~': {
                token = this.getSyntaxToken(SyntaxKind.NEGATION_TOKEN);
                break;
            }
            case '`': {
                this.startMode(ParserMode.TEMPLATE);
                token = this.getBacktickToken();
                break;
            }
            case '\'': {
                token = this.processQuotedIdentifier();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                token = this.processNumericLiteral(c);
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                token = this.processIdentifierOrKeyword();
                break;
            }
            default: {
                STToken invalidToken = this.processInvalidToken();
                token = this.nextToken();
                token = SyntaxErrors.addDiagnostic(token, DiagnosticErrorCode.ERROR_INVALID_TOKEN, invalidToken);
            }
        }
        return token;
    }

    private STToken getSyntaxToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getIdentifierToken() {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createIdentifierToken(lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getLiteral(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private void processLeadingTrivia() {
        this.processSyntaxTrivia(this.leadingTriviaList, true);
    }

    private STNode processTrailingTrivia() {
        ArrayList<STNode> triviaList = new ArrayList<STNode>(10);
        this.processSyntaxTrivia(triviaList, false);
        return STNodeFactory.createNodeList(triviaList);
    }

    private void processSyntaxTrivia(List<STNode> triviaList, boolean isLeading) {
        while (!this.reader.isEOF()) {
            this.reader.mark();
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    triviaList.add(this.processWhitespaces());
                    break;
                }
                case '\n': 
                case '\r': {
                    triviaList.add(this.processEndOfLine());
                    if (isLeading) break;
                    return;
                }
                case '/': {
                    if (this.reader.peek(1) == '/') {
                        triviaList.add(this.processComment());
                        break;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    private STNode processWhitespaces() {
        block4: while (!this.reader.isEOF()) {
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    this.reader.advance();
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.WHITESPACE_MINUTIAE, this.getLexeme());
    }

    private STNode processEndOfLine() {
        char c = this.reader.peek();
        switch (c) {
            case '\n': {
                this.reader.advance();
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
            case '\r': {
                this.reader.advance();
                if (this.reader.peek() == '\n') {
                    this.reader.advance();
                }
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
        }
        throw new IllegalStateException();
    }

    private STToken processDot() {
        char nextChar = this.reader.peek();
        if (nextChar == '.') {
            char nextNextChar = this.reader.peek(1);
            if (nextNextChar == '.') {
                this.reader.advance(2);
                return this.getSyntaxToken(SyntaxKind.ELLIPSIS_TOKEN);
            }
            if (nextNextChar == '<') {
                this.reader.advance(2);
                return this.getSyntaxToken(SyntaxKind.DOUBLE_DOT_LT_TOKEN);
            }
        } else {
            if (nextChar == '@') {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.ANNOT_CHAINING_TOKEN);
            }
            if (nextChar == '<') {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.DOT_LT_TOKEN);
            }
        }
        if (this.mode != ParserMode.IMPORT && BallerinaLexer.isDigit(nextChar)) {
            return this.processDecimalFloatLiteral();
        }
        return this.getSyntaxToken(SyntaxKind.DOT_TOKEN);
    }

    private STNode processComment() {
        this.reader.advance(2);
        int nextToken = this.peek();
        block3: while (!this.reader.isEOF()) {
            switch (nextToken) {
                case 10: 
                case 13: {
                    break block3;
                }
                default: {
                    this.reader.advance();
                    nextToken = this.peek();
                    continue block3;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.COMMENT_MINUTIAE, this.getLexeme());
    }

    private STToken processEqualOperator() {
        switch (this.peek()) {
            case 61: {
                this.reader.advance();
                if (this.peek() == 61) {
                    this.reader.advance();
                    return this.getSyntaxToken(SyntaxKind.TRIPPLE_EQUAL_TOKEN);
                }
                return this.getSyntaxToken(SyntaxKind.DOUBLE_EQUAL_TOKEN);
            }
            case 62: {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN);
            }
        }
        return this.getSyntaxToken(SyntaxKind.EQUAL_TOKEN);
    }

    private STToken processNumericLiteral(int startChar) {
        int nextChar = this.peek();
        if (this.isHexIndicator(startChar, nextChar)) {
            return this.processHexLiteral();
        }
        int len = 1;
        block3: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 46: 
                case 68: 
                case 69: 
                case 70: 
                case 100: 
                case 101: 
                case 102: {
                    if (this.reader.peek(1) == '.' || this.mode == ParserMode.IMPORT) break block3;
                    if (startChar == 48 && len > 1) {
                        this.reportLexerError(DiagnosticErrorCode.ERROR_LEADING_ZEROS_IN_NUMERIC_LITERALS, new Object[0]);
                    }
                    return this.processDecimalFloatLiteral();
                }
                default: {
                    if (!BallerinaLexer.isDigit(nextChar)) break block3;
                    this.reader.advance();
                    ++len;
                    nextChar = this.peek();
                    continue block3;
                }
            }
        }
        if (startChar == 48 && len > 1) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_LEADING_ZEROS_IN_NUMERIC_LITERALS, new Object[0]);
        }
        return this.getLiteral(SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN);
    }

    private STToken processDecimalFloatLiteral() {
        int nextChar = this.peek();
        if (nextChar == 46) {
            this.reader.advance();
            nextChar = this.peek();
        }
        while (BallerinaLexer.isDigit(nextChar)) {
            this.reader.advance();
            nextChar = this.peek();
        }
        switch (nextChar) {
            case 69: 
            case 101: {
                return this.processExponent(false);
            }
            case 68: 
            case 70: 
            case 100: 
            case 102: {
                return this.parseFloatingPointTypeSuffix();
            }
        }
        return this.getLiteral(SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN);
    }

    private STToken processExponent(boolean isHex) {
        this.reader.advance();
        int nextChar = this.peek();
        if (nextChar == 43 || nextChar == 45) {
            this.reader.advance();
            nextChar = this.peek();
        }
        if (!BallerinaLexer.isDigit(nextChar)) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_DIGIT_AFTER_EXPONENT_INDICATOR, new Object[0]);
        }
        while (BallerinaLexer.isDigit(nextChar)) {
            this.reader.advance();
            nextChar = this.peek();
        }
        if (isHex) {
            return this.getLiteral(SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN);
        }
        switch (nextChar) {
            case 68: 
            case 70: 
            case 100: 
            case 102: {
                return this.parseFloatingPointTypeSuffix();
            }
        }
        return this.getLiteral(SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN);
    }

    private STToken parseFloatingPointTypeSuffix() {
        this.reader.advance();
        return this.getLiteral(SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN);
    }

    private STToken processHexLiteral() {
        this.reader.advance();
        if (this.peek() == 46 && !BallerinaLexer.isHexDigit(this.reader.peek(1))) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_HEX_DIGIT_AFTER_DOT, new Object[0]);
        }
        while (BallerinaLexer.isHexDigit(this.peek())) {
            this.reader.advance();
        }
        int nextChar = this.peek();
        switch (nextChar) {
            case 46: {
                this.reader.advance();
                nextChar = this.peek();
                while (BallerinaLexer.isHexDigit(nextChar)) {
                    this.reader.advance();
                    nextChar = this.peek();
                }
                switch (nextChar) {
                    case 80: 
                    case 112: {
                        return this.processExponent(true);
                    }
                }
                break;
            }
            case 80: 
            case 112: {
                return this.processExponent(true);
            }
            default: {
                return this.getLiteral(SyntaxKind.HEX_INTEGER_LITERAL_TOKEN);
            }
        }
        return this.getLiteral(SyntaxKind.HEX_FLOATING_POINT_LITERAL_TOKEN);
    }

    private STToken processIdentifierOrKeyword() {
        String tokenText;
        while (this.isIdentifierFollowingChar(this.peek())) {
            this.reader.advance();
        }
        switch (tokenText = this.getLexeme()) {
            case "int": {
                return this.getSyntaxToken(SyntaxKind.INT_KEYWORD);
            }
            case "float": {
                return this.getSyntaxToken(SyntaxKind.FLOAT_KEYWORD);
            }
            case "string": {
                return this.getSyntaxToken(SyntaxKind.STRING_KEYWORD);
            }
            case "boolean": {
                return this.getSyntaxToken(SyntaxKind.BOOLEAN_KEYWORD);
            }
            case "decimal": {
                return this.getSyntaxToken(SyntaxKind.DECIMAL_KEYWORD);
            }
            case "xml": {
                return this.getSyntaxToken(SyntaxKind.XML_KEYWORD);
            }
            case "json": {
                return this.getSyntaxToken(SyntaxKind.JSON_KEYWORD);
            }
            case "handle": {
                return this.getSyntaxToken(SyntaxKind.HANDLE_KEYWORD);
            }
            case "any": {
                return this.getSyntaxToken(SyntaxKind.ANY_KEYWORD);
            }
            case "anydata": {
                return this.getSyntaxToken(SyntaxKind.ANYDATA_KEYWORD);
            }
            case "never": {
                return this.getSyntaxToken(SyntaxKind.NEVER_KEYWORD);
            }
            case "byte": {
                return this.getSyntaxToken(SyntaxKind.BYTE_KEYWORD);
            }
            case "public": {
                return this.getSyntaxToken(SyntaxKind.PUBLIC_KEYWORD);
            }
            case "private": {
                return this.getSyntaxToken(SyntaxKind.PRIVATE_KEYWORD);
            }
            case "function": {
                return this.getSyntaxToken(SyntaxKind.FUNCTION_KEYWORD);
            }
            case "return": {
                return this.getSyntaxToken(SyntaxKind.RETURN_KEYWORD);
            }
            case "returns": {
                return this.getSyntaxToken(SyntaxKind.RETURNS_KEYWORD);
            }
            case "external": {
                return this.getSyntaxToken(SyntaxKind.EXTERNAL_KEYWORD);
            }
            case "type": {
                return this.getSyntaxToken(SyntaxKind.TYPE_KEYWORD);
            }
            case "record": {
                return this.getSyntaxToken(SyntaxKind.RECORD_KEYWORD);
            }
            case "object": {
                return this.getSyntaxToken(SyntaxKind.OBJECT_KEYWORD);
            }
            case "remote": {
                return this.getSyntaxToken(SyntaxKind.REMOTE_KEYWORD);
            }
            case "abstract": {
                return this.getSyntaxToken(SyntaxKind.ABSTRACT_KEYWORD);
            }
            case "client": {
                return this.getSyntaxToken(SyntaxKind.CLIENT_KEYWORD);
            }
            case "if": {
                return this.getSyntaxToken(SyntaxKind.IF_KEYWORD);
            }
            case "else": {
                return this.getSyntaxToken(SyntaxKind.ELSE_KEYWORD);
            }
            case "while": {
                return this.getSyntaxToken(SyntaxKind.WHILE_KEYWORD);
            }
            case "true": {
                return this.getSyntaxToken(SyntaxKind.TRUE_KEYWORD);
            }
            case "false": {
                return this.getSyntaxToken(SyntaxKind.FALSE_KEYWORD);
            }
            case "check": {
                return this.getSyntaxToken(SyntaxKind.CHECK_KEYWORD);
            }
            case "fail": {
                return this.getSyntaxToken(SyntaxKind.FAIL_KEYWORD);
            }
            case "checkpanic": {
                return this.getSyntaxToken(SyntaxKind.CHECKPANIC_KEYWORD);
            }
            case "continue": {
                return this.getSyntaxToken(SyntaxKind.CONTINUE_KEYWORD);
            }
            case "break": {
                return this.getSyntaxToken(SyntaxKind.BREAK_KEYWORD);
            }
            case "panic": {
                return this.getSyntaxToken(SyntaxKind.PANIC_KEYWORD);
            }
            case "import": {
                return this.getSyntaxToken(SyntaxKind.IMPORT_KEYWORD);
            }
            case "version": {
                return this.getSyntaxToken(SyntaxKind.VERSION_KEYWORD);
            }
            case "as": {
                return this.getSyntaxToken(SyntaxKind.AS_KEYWORD);
            }
            case "service": {
                return this.getSyntaxToken(SyntaxKind.SERVICE_KEYWORD);
            }
            case "on": {
                return this.getSyntaxToken(SyntaxKind.ON_KEYWORD);
            }
            case "resource": {
                return this.getSyntaxToken(SyntaxKind.RESOURCE_KEYWORD);
            }
            case "listener": {
                return this.getSyntaxToken(SyntaxKind.LISTENER_KEYWORD);
            }
            case "const": {
                return this.getSyntaxToken(SyntaxKind.CONST_KEYWORD);
            }
            case "final": {
                return this.getSyntaxToken(SyntaxKind.FINAL_KEYWORD);
            }
            case "typeof": {
                return this.getSyntaxToken(SyntaxKind.TYPEOF_KEYWORD);
            }
            case "is": {
                return this.getSyntaxToken(SyntaxKind.IS_KEYWORD);
            }
            case "null": {
                return this.getSyntaxToken(SyntaxKind.NULL_KEYWORD);
            }
            case "lock": {
                return this.getSyntaxToken(SyntaxKind.LOCK_KEYWORD);
            }
            case "annotation": {
                return this.getSyntaxToken(SyntaxKind.ANNOTATION_KEYWORD);
            }
            case "source": {
                return this.getSyntaxToken(SyntaxKind.SOURCE_KEYWORD);
            }
            case "var": {
                return this.getSyntaxToken(SyntaxKind.VAR_KEYWORD);
            }
            case "worker": {
                return this.getSyntaxToken(SyntaxKind.WORKER_KEYWORD);
            }
            case "parameter": {
                return this.getSyntaxToken(SyntaxKind.PARAMETER_KEYWORD);
            }
            case "field": {
                return this.getSyntaxToken(SyntaxKind.FIELD_KEYWORD);
            }
            case "isolated": {
                return this.getSyntaxToken(SyntaxKind.ISOLATED_KEYWORD);
            }
            case "xmlns": {
                return this.getSyntaxToken(SyntaxKind.XMLNS_KEYWORD);
            }
            case "fork": {
                return this.getSyntaxToken(SyntaxKind.FORK_KEYWORD);
            }
            case "map": {
                return this.getSyntaxToken(SyntaxKind.MAP_KEYWORD);
            }
            case "future": {
                return this.getSyntaxToken(SyntaxKind.FUTURE_KEYWORD);
            }
            case "typedesc": {
                return this.getSyntaxToken(SyntaxKind.TYPEDESC_KEYWORD);
            }
            case "trap": {
                return this.getSyntaxToken(SyntaxKind.TRAP_KEYWORD);
            }
            case "in": {
                return this.getSyntaxToken(SyntaxKind.IN_KEYWORD);
            }
            case "foreach": {
                return this.getSyntaxToken(SyntaxKind.FOREACH_KEYWORD);
            }
            case "table": {
                return this.getSyntaxToken(SyntaxKind.TABLE_KEYWORD);
            }
            case "error": {
                return this.getSyntaxToken(SyntaxKind.ERROR_KEYWORD);
            }
            case "let": {
                return this.getSyntaxToken(SyntaxKind.LET_KEYWORD);
            }
            case "stream": {
                return this.getSyntaxToken(SyntaxKind.STREAM_KEYWORD);
            }
            case "new": {
                return this.getSyntaxToken(SyntaxKind.NEW_KEYWORD);
            }
            case "readonly": {
                return this.getSyntaxToken(SyntaxKind.READONLY_KEYWORD);
            }
            case "distinct": {
                return this.getSyntaxToken(SyntaxKind.DISTINCT_KEYWORD);
            }
            case "from": {
                return this.getSyntaxToken(SyntaxKind.FROM_KEYWORD);
            }
            case "where": {
                return this.getSyntaxToken(SyntaxKind.WHERE_KEYWORD);
            }
            case "select": {
                return this.getSyntaxToken(SyntaxKind.SELECT_KEYWORD);
            }
            case "start": {
                return this.getSyntaxToken(SyntaxKind.START_KEYWORD);
            }
            case "flush": {
                return this.getSyntaxToken(SyntaxKind.FLUSH_KEYWORD);
            }
            case "default": {
                return this.getSyntaxToken(SyntaxKind.DEFAULT_KEYWORD);
            }
            case "wait": {
                return this.getSyntaxToken(SyntaxKind.WAIT_KEYWORD);
            }
            case "do": {
                return this.getSyntaxToken(SyntaxKind.DO_KEYWORD);
            }
            case "transaction": {
                return this.getSyntaxToken(SyntaxKind.TRANSACTION_KEYWORD);
            }
            case "commit": {
                return this.getSyntaxToken(SyntaxKind.COMMIT_KEYWORD);
            }
            case "retry": {
                return this.getSyntaxToken(SyntaxKind.RETRY_KEYWORD);
            }
            case "rollback": {
                return this.getSyntaxToken(SyntaxKind.ROLLBACK_KEYWORD);
            }
            case "transactional": {
                return this.getSyntaxToken(SyntaxKind.TRANSACTIONAL_KEYWORD);
            }
            case "enum": {
                return this.getSyntaxToken(SyntaxKind.ENUM_KEYWORD);
            }
            case "base16": {
                return this.getSyntaxToken(SyntaxKind.BASE16_KEYWORD);
            }
            case "base64": {
                return this.getSyntaxToken(SyntaxKind.BASE64_KEYWORD);
            }
            case "match": {
                return this.getSyntaxToken(SyntaxKind.MATCH_KEYWORD);
            }
            case "conflict": {
                return this.getSyntaxToken(SyntaxKind.CONFLICT_KEYWORD);
            }
            case "limit": {
                return this.getSyntaxToken(SyntaxKind.LIMIT_KEYWORD);
            }
            case "join": {
                return this.getSyntaxToken(SyntaxKind.JOIN_KEYWORD);
            }
            case "outer": {
                return this.getSyntaxToken(SyntaxKind.OUTER_KEYWORD);
            }
            case "equals": {
                return this.getSyntaxToken(SyntaxKind.EQUALS_KEYWORD);
            }
            case "order": {
                return this.getSyntaxToken(SyntaxKind.ORDER_KEYWORD);
            }
            case "by": {
                return this.getSyntaxToken(SyntaxKind.BY_KEYWORD);
            }
            case "ascending": {
                return this.getSyntaxToken(SyntaxKind.ASCENDING_KEYWORD);
            }
            case "descending": {
                return this.getSyntaxToken(SyntaxKind.DESCENDING_KEYWORD);
            }
            case "class": {
                return this.getSyntaxToken(SyntaxKind.CLASS_KEYWORD);
            }
            case "configurable": {
                return this.getSyntaxToken(SyntaxKind.CONFIGURABLE_KEYWORD);
            }
        }
        return this.getIdentifierToken();
    }

    private STToken processInvalidToken() {
        while (!this.isEndOfInvalidToken()) {
            this.reader.advance();
        }
        String tokenText = this.getLexeme();
        STToken invalidToken = STNodeFactory.createInvalidToken(tokenText);
        STNode invalidNodeMinutiae = STNodeFactory.createInvalidNodeMinutiae(invalidToken);
        this.leadingTriviaList.add(invalidNodeMinutiae);
        return invalidToken;
    }

    private boolean isEndOfInvalidToken() {
        if (this.reader.isEOF()) {
            return true;
        }
        int currentChar = this.peek();
        switch (currentChar) {
            case 9: 
            case 10: 
            case 13: 
            case 32: 
            case 40: 
            case 41: 
            case 59: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private boolean isIdentifierInitialChar(int c) {
        if (65 <= c && c <= 90) {
            return true;
        }
        if (97 <= c && c <= 122) {
            return true;
        }
        if (c == 95) {
            return true;
        }
        return this.isUnicodeIdentifierChar(c);
    }

    private boolean isUnicodeIdentifierChar(int c) {
        if (0 <= c && c <= 127) {
            return false;
        }
        if (this.isUnicodePrivateUseChar(c) || this.isUnicodePatternWhiteSpaceChar(c)) {
            return false;
        }
        return c != 65535;
    }

    private boolean isUnicodePatternWhiteSpaceChar(int c) {
        return 8206 == c || 8207 == c || 8232 == c || 8233 == c;
    }

    private boolean isUnicodePrivateUseChar(int c) {
        return 57344 <= c && c <= 63743 || 983040 <= c && c <= 1048573 || 0x100000 <= c && c <= 1114109;
    }

    private boolean isIdentifierFollowingChar(int c) {
        return this.isIdentifierInitialChar(c) || BallerinaLexer.isDigit(c);
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    static boolean isHexDigit(int c) {
        if (97 <= c && c <= 102) {
            return true;
        }
        if (65 <= c && c <= 70) {
            return true;
        }
        return BallerinaLexer.isDigit(c);
    }

    private boolean isHexIndicator(int startChar, int nextChar) {
        return startChar == 48 && (nextChar == 120 || nextChar == 88);
    }

    private int peek() {
        return this.reader.peek();
    }

    private String getLexeme() {
        return this.reader.getMarkedChars();
    }

    private STToken processStringLiteral() {
        block9: while (!this.reader.isEOF()) {
            int nextChar = this.peek();
            switch (nextChar) {
                case 10: 
                case 13: {
                    this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_DOUBLE_QUOTE, new Object[0]);
                    break block9;
                }
                case 34: {
                    this.reader.advance();
                    break block9;
                }
                case 92: {
                    switch (this.reader.peek(1)) {
                        case '\"': 
                        case '\\': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            this.reader.advance(2);
                            continue block9;
                        }
                        case 'u': {
                            if (this.reader.peek(2) == '{') {
                                this.processStringNumericEscape();
                                continue block9;
                            }
                            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_STRING_NUMERIC_ESCAPE_SEQUENCE, new Object[0]);
                            this.reader.advance(2);
                            continue block9;
                        }
                    }
                    String escapeSequence = String.valueOf(this.reader.peek(2));
                    this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_ESCAPE_SEQUENCE, escapeSequence);
                    this.reader.advance();
                    continue block9;
                }
                default: {
                    this.reader.advance();
                    continue block9;
                }
            }
        }
        return this.getLiteral(SyntaxKind.STRING_LITERAL_TOKEN);
    }

    private void processStringNumericEscape() {
        this.reader.advance(3);
        if (!BallerinaLexer.isHexDigit(this.peek())) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_STRING_NUMERIC_ESCAPE_SEQUENCE, new Object[0]);
            return;
        }
        this.reader.advance();
        while (BallerinaLexer.isHexDigit(this.peek())) {
            this.reader.advance();
        }
        if (this.peek() != 125) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_STRING_NUMERIC_ESCAPE_SEQUENCE, new Object[0]);
            return;
        }
        this.reader.advance();
    }

    private STToken processExclamationMarkOperator() {
        switch (this.peek()) {
            case 61: {
                this.reader.advance();
                if (this.peek() == 61) {
                    this.reader.advance();
                    return this.getSyntaxToken(SyntaxKind.NOT_DOUBLE_EQUAL_TOKEN);
                }
                return this.getSyntaxToken(SyntaxKind.NOT_EQUAL_TOKEN);
            }
        }
        return this.getSyntaxToken(SyntaxKind.EXCLAMATION_MARK_TOKEN);
    }

    private STToken processPipeOperator() {
        switch (this.peek()) {
            case 125: {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.CLOSE_BRACE_PIPE_TOKEN);
            }
            case 124: {
                this.reader.advance();
                return this.getSyntaxToken(SyntaxKind.LOGICAL_OR_TOKEN);
            }
        }
        return this.getSyntaxToken(SyntaxKind.PIPE_TOKEN);
    }

    private STToken processSlashToken() {
        if (this.peek() != 42) {
            return this.getSyntaxToken(SyntaxKind.SLASH_TOKEN);
        }
        this.reader.advance();
        if (this.peek() != 42) {
            return this.getSyntaxToken(SyntaxKind.SLASH_ASTERISK_TOKEN);
        }
        if (this.reader.peek(1) == '/' && this.reader.peek(2) == '<') {
            this.reader.advance(3);
            return this.getSyntaxToken(SyntaxKind.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN);
        }
        return this.getSyntaxToken(SyntaxKind.SLASH_ASTERISK_TOKEN);
    }

    private STToken processDocumentationString() {
        int nextChar = this.peek();
        block3: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 10: 
                case 13: {
                    if (this.peek() == 13 && this.reader.peek(1) == '\n') {
                        this.reader.advance();
                    }
                    this.reader.advance();
                    int lookAheadCount = 0;
                    char lookAheadChar = this.reader.peek(lookAheadCount);
                    while (lookAheadChar == ' ' || lookAheadChar == '\t') {
                        lookAheadChar = this.reader.peek(++lookAheadCount);
                    }
                    if (lookAheadChar != '#') break block3;
                    this.reader.advance(lookAheadCount);
                    nextChar = this.peek();
                    continue block3;
                }
                default: {
                    this.reader.advance();
                    nextChar = this.peek();
                    continue block3;
                }
            }
        }
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = STNodeFactory.createNodeList(new ArrayList<STNode>(0));
        return STNodeFactory.createLiteralValueToken(SyntaxKind.DOCUMENTATION_STRING, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getBacktickToken() {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = STNodeFactory.createEmptyNodeList();
        return STNodeFactory.createToken(SyntaxKind.BACKTICK_TOKEN, leadingTrivia, trailingTrivia);
    }

    private STToken readTemplateToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        switch (nextChar) {
            case '`': {
                this.reader.advance();
                this.endMode();
                return this.getSyntaxToken(SyntaxKind.BACKTICK_TOKEN);
            }
            case '$': {
                if (this.reader.peek(1) != '{') break;
                this.startMode(ParserMode.INTERPOLATION);
                this.reader.advance(2);
                return this.getSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
            }
        }
        block8: while (!this.reader.isEOF()) {
            nextChar = this.reader.peek();
            switch (nextChar) {
                case '$': {
                    if (this.reader.peek(1) == '{') break block8;
                    this.reader.advance();
                    continue block8;
                }
                case '`': {
                    break block8;
                }
                default: {
                    this.reader.advance();
                    continue block8;
                }
            }
        }
        return this.getLiteral(SyntaxKind.TEMPLATE_STRING);
    }

    private STToken processQuotedIdentifier() {
        block4: while (!this.reader.isEOF()) {
            char nextChar = this.reader.peek();
            if (this.isIdentifierFollowingChar(nextChar)) {
                this.reader.advance();
                continue;
            }
            if (nextChar != '\\') break;
            nextChar = this.reader.peek(1);
            switch (nextChar) {
                case '\t': 
                case '\n': 
                case '\r': {
                    break block4;
                }
                case 'u': {
                    if (this.reader.peek(2) == '{') {
                        this.processStringNumericEscape();
                        continue block4;
                    }
                    this.reader.advance(2);
                    continue block4;
                }
                default: {
                    if (!this.isValidQuotedIdentifierEscapeChar(nextChar)) {
                        String escapeSequence = String.valueOf(nextChar);
                        this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_ESCAPE_SEQUENCE, escapeSequence);
                    }
                    this.reader.advance(2);
                    continue block4;
                }
            }
        }
        return this.getIdentifierToken();
    }

    private boolean isValidQuotedIdentifierEscapeChar(int nextChar) {
        if (65 <= nextChar && nextChar <= 90) {
            return false;
        }
        if (97 <= nextChar && nextChar <= 122) {
            return false;
        }
        return !this.isUnicodePatternWhiteSpaceChar(nextChar);
    }

    private STToken processTokenStartWithGt() {
        if (this.peek() == 61) {
            this.reader.advance();
            return this.getSyntaxToken(SyntaxKind.GT_EQUAL_TOKEN);
        }
        if (this.reader.peek() != '>') {
            return this.getSyntaxToken(SyntaxKind.GT_TOKEN);
        }
        char nextChar = this.reader.peek(1);
        switch (nextChar) {
            case '>': {
                if (this.reader.peek(2) == '=') {
                    this.reader.advance(2);
                    return this.getSyntaxToken(SyntaxKind.TRIPPLE_GT_TOKEN);
                }
                return this.getSyntaxToken(SyntaxKind.GT_TOKEN);
            }
            case '=': {
                this.reader.advance(1);
                return this.getSyntaxToken(SyntaxKind.DOUBLE_GT_TOKEN);
            }
        }
        return this.getSyntaxToken(SyntaxKind.GT_TOKEN);
    }

    private STToken readTokenInInterpolation() {
        this.reader.mark();
        int nextChar = this.peek();
        switch (nextChar) {
            case 123: {
                this.startMode(ParserMode.INTERPOLATION_BRACED_CONTENT);
                return this.readToken();
            }
            case 125: {
                this.endMode();
                this.reader.advance();
                return this.getSyntaxTokenWithoutTrailingTrivia(SyntaxKind.CLOSE_BRACE_TOKEN);
            }
        }
        return this.readToken();
    }

    private STToken getSyntaxTokenWithoutTrailingTrivia(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = STNodeFactory.createNodeList(new ArrayList<STNode>(0));
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken readTokenInBracedContentInInterpolation() {
        this.reader.mark();
        int nextChar = this.peek();
        switch (nextChar) {
            case 123: {
                this.startMode(ParserMode.INTERPOLATION_BRACED_CONTENT);
                break;
            }
            case 96: 
            case 125: {
                this.endMode();
                break;
            }
        }
        return this.readToken();
    }
}

