/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticWarningCode;
import io.ballerina.compiler.internal.parser.AbstractLexer;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DocumentationLexer
extends AbstractLexer {
    private BacktickReferenceMode referenceMode = BacktickReferenceMode.NO_KEYWORD;
    private static final char[] deprecatedChars = new char[]{'D', 'e', 'p', 'r', 'e', 'c', 'a', 't', 'e', 'd'};
    private int lookAheadNumber = 0;
    private boolean hasMatch = true;

    public DocumentationLexer(CharReader charReader, List<STNode> leadingTriviaList, Collection<STNodeDiagnostic> diagnostics) {
        super(charReader, ParserMode.DOCUMENTATION_INIT, leadingTriviaList, diagnostics);
    }

    @Override
    public STToken nextToken() {
        STToken token;
        switch (this.mode) {
            case DOCUMENTATION_INIT: {
                this.processLeadingTrivia();
                token = this.readDocumentationInitToken();
                break;
            }
            case DOCUMENTATION: {
                token = this.readDocumentationToken();
                break;
            }
            case DOCUMENTATION_INTERNAL: {
                token = this.readDocumentationInternalToken();
                break;
            }
            case DOCUMENTATION_PARAMETER: {
                this.processLeadingTrivia();
                token = this.readDocumentationParameterToken();
                break;
            }
            case DOCUMENTATION_REFERENCE_TYPE: {
                this.processLeadingTrivia();
                token = this.readDocumentationReferenceTypeToken();
                break;
            }
            case DOCUMENTATION_BACKTICK_CONTENT: {
                token = this.readDocumentationBacktickContentToken();
                break;
            }
            case DOCUMENTATION_BACKTICK_EXPR: {
                token = this.readDocumentationBacktickExprToken();
                break;
            }
            default: {
                token = null;
            }
        }
        return this.cloneWithDiagnostics(token);
    }

    private int peek() {
        return this.reader.peek();
    }

    private String getLexeme() {
        return this.reader.getMarkedChars();
    }

    private boolean isIdentifierInitialChar(int c) {
        if (65 <= c && c <= 90) {
            return true;
        }
        if (97 <= c && c <= 122) {
            return true;
        }
        return c == 95;
    }

    private boolean isIdentifierFollowingChar(int c) {
        return this.isIdentifierInitialChar(c) || DocumentationLexer.isDigit(c);
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private void processLeadingTrivia() {
        this.processSyntaxTrivia(this.leadingTriviaList, true);
    }

    private STNode processTrailingTrivia() {
        ArrayList<STNode> triviaList = new ArrayList<STNode>(10);
        this.processSyntaxTrivia(triviaList, false);
        return STNodeFactory.createNodeList(triviaList);
    }

    private void processSyntaxTrivia(List<STNode> triviaList, boolean isLeading) {
        while (!this.reader.isEOF()) {
            this.reader.mark();
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    triviaList.add(this.processWhitespaces());
                    break;
                }
                case '\n': 
                case '\r': {
                    triviaList.add(this.processEndOfLine());
                    if (isLeading) break;
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    private STNode processWhitespaces() {
        block4: while (!this.reader.isEOF()) {
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    this.reader.advance();
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.WHITESPACE_MINUTIAE, this.getLexeme());
    }

    private STNode processEndOfLine() {
        char c = this.reader.peek();
        switch (c) {
            case '\n': {
                this.reader.advance();
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
            case '\r': {
                this.reader.advance();
                if (this.reader.peek() == '\n') {
                    this.reader.advance();
                }
                return STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, this.getLexeme());
            }
        }
        throw new IllegalStateException();
    }

    private void setReferenceMode(BacktickReferenceMode mode) {
        this.referenceMode = mode;
    }

    private void resetReferenceMode() {
        this.referenceMode = BacktickReferenceMode.NO_KEYWORD;
    }

    private void resetSearchProperties() {
        this.lookAheadNumber = 0;
        this.hasMatch = true;
    }

    private int getLookAheadChar() {
        return this.reader.peek(this.lookAheadNumber);
    }

    private void consumeChar() {
        ++this.lookAheadNumber;
    }

    private STToken getDocumentationSyntaxToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = this.processTrailingTrivia();
        int bucketCount = trailingTrivia.bucketCount();
        if (bucketCount > 0 && trailingTrivia.childInBucket((int)(bucketCount - 1)).kind == SyntaxKind.END_OF_LINE_MINUTIAE) {
            this.endMode();
        }
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getDocumentationSyntaxTokenWithNoTrivia(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        ArrayList<STNode> triviaList = new ArrayList<STNode>(1);
        int nextChar = this.peek();
        if (nextChar == 10 || nextChar == 13) {
            this.reader.mark();
            triviaList.add(this.processEndOfLine());
            this.endMode();
        }
        STNode trailingTrivia = STNodeFactory.createNodeList(triviaList);
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getDocumentationLiteral(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        int bucketCount = trailingTrivia.bucketCount();
        if (bucketCount > 0 && trailingTrivia.childInBucket((int)(bucketCount - 1)).kind == SyntaxKind.END_OF_LINE_MINUTIAE) {
            this.endMode();
        }
        return STNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getDocumentationDescriptionToken() {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createLiteralValueToken(SyntaxKind.DOCUMENTATION_DESCRIPTION, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getIdentifierToken() {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createIdentifierToken(lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken readDocumentationInitToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getDocumentationSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        if (nextChar == 35) {
            this.reader.advance();
            this.startMode(ParserMode.DOCUMENTATION);
            return this.getDocumentationSyntaxTokenWithNoTrivia(SyntaxKind.HASH_TOKEN);
        }
        throw new IllegalStateException("documentation line should always start with a hash");
    }

    private STToken readDocumentationToken() {
        int lookAheadCount = 0;
        char lookAheadChar = this.reader.peek(lookAheadCount);
        while (lookAheadChar == ' ' || lookAheadChar == '\t') {
            lookAheadChar = this.reader.peek(++lookAheadCount);
        }
        if (lookAheadChar == '+') {
            return this.processPlusToken();
        }
        if (lookAheadChar == '#') {
            return this.processDeprecationLiteralToken(lookAheadCount);
        }
        return this.readDocumentationInternalToken();
    }

    private STToken processPlusToken() {
        this.processLeadingTrivia();
        this.reader.advance();
        this.switchMode(ParserMode.DOCUMENTATION_PARAMETER);
        return this.getDocumentationSyntaxToken(SyntaxKind.PLUS_TOKEN);
    }

    private STToken processDeprecationLiteralToken(int lookAheadCount) {
        char lookAheadChar = this.reader.peek(++lookAheadCount);
        int whitespaceCount = 0;
        while (lookAheadChar == ' ' || lookAheadChar == '\t') {
            ++whitespaceCount;
            lookAheadChar = this.reader.peek(++lookAheadCount);
        }
        for (int i = 0; i < 10; ++i) {
            if ((char)lookAheadChar != deprecatedChars[i]) {
                return this.readDocumentationInternalToken();
            }
            lookAheadChar = this.reader.peek(++lookAheadCount);
        }
        this.processLeadingTrivia();
        this.reader.mark();
        this.reader.advance();
        this.reader.advance(whitespaceCount);
        this.reader.advance(10);
        return this.getDocumentationLiteral(SyntaxKind.DEPRECATION_LITERAL);
    }

    private STToken readDocumentationInternalToken() {
        this.reader.mark();
        int nextChar = this.peek();
        if (nextChar == 96 && this.reader.peek(1) != '`') {
            this.reader.advance();
            this.switchMode(ParserMode.DOCUMENTATION_BACKTICK_CONTENT);
            return this.getDocumentationSyntaxToken(SyntaxKind.BACKTICK_TOKEN);
        }
        block4: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 10: 
                case 13: {
                    this.endMode();
                    break block4;
                }
                case 96: {
                    if (this.reader.peek(1) != '`') break block4;
                    if (this.reader.peek(2) != '`') {
                        this.reader.advance(2);
                        this.processDocumentationCodeContent(false);
                    } else {
                        this.reader.advance(3);
                        this.processDocumentationCodeContent(true);
                    }
                    nextChar = this.peek();
                    continue block4;
                }
                default: {
                    if (this.isIdentifierInitialChar(nextChar)) {
                        boolean hasDocumentationReference = this.processDocumentationReference(nextChar);
                        if (hasDocumentationReference) {
                            this.switchMode(ParserMode.DOCUMENTATION_REFERENCE_TYPE);
                            break block4;
                        }
                    } else {
                        this.reader.advance();
                    }
                    nextChar = this.peek();
                    continue block4;
                }
            }
        }
        if (this.getLexeme().isEmpty()) {
            return this.readDocumentationReferenceTypeToken();
        }
        return this.getDocumentationDescriptionToken();
    }

    private void processDocumentationCodeContent(boolean isTripleBacktick) {
        int nextChar = this.peek();
        block4: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 96: {
                    if (isTripleBacktick) {
                        this.reader.advance();
                        if (this.peek() != 96) {
                            nextChar = this.peek();
                            continue block4;
                        }
                    }
                    this.reader.advance();
                    if (this.peek() != 96) {
                        nextChar = this.peek();
                        continue block4;
                    }
                    this.reader.advance();
                    if (this.peek() != 96) {
                        return;
                    }
                    nextChar = this.peek();
                    continue block4;
                }
                case 10: 
                case 13: {
                    int lookAheadCount = 1;
                    if (this.peek() == 13 && this.reader.peek(1) == '\n') {
                        ++lookAheadCount;
                    }
                    char lookAheadChar = this.reader.peek(lookAheadCount);
                    while (lookAheadChar == ' ' || lookAheadChar == '\t') {
                        lookAheadChar = this.reader.peek(++lookAheadCount);
                    }
                    if (lookAheadChar != '#') {
                        return;
                    }
                    this.reader.advance(lookAheadCount);
                    nextChar = this.peek();
                    continue block4;
                }
            }
            this.reader.advance();
            nextChar = this.peek();
        }
    }

    private boolean processDocumentationReference(int nextChar) {
        int lookAheadChar = nextChar;
        int lookAheadCount = 0;
        String identifier = "";
        while (this.isIdentifierInitialChar(lookAheadChar)) {
            identifier = identifier.concat(String.valueOf((char)lookAheadChar));
            lookAheadChar = this.reader.peek(++lookAheadCount);
        }
        switch (identifier) {
            case "type": 
            case "service": 
            case "variable": 
            case "var": 
            case "annotation": 
            case "module": 
            case "function": 
            case "parameter": 
            case "const": {
                block19: while (true) {
                    switch (lookAheadChar) {
                        case 9: 
                        case 32: {
                            lookAheadChar = this.reader.peek(++lookAheadCount);
                            continue block19;
                        }
                        case 96: {
                            if (this.reader.peek(lookAheadCount + 1) == '`') break block19;
                            return true;
                        }
                    }
                    break;
                }
                break;
            }
        }
        this.reader.advance(lookAheadCount);
        return false;
    }

    private STToken readDocumentationParameterToken() {
        this.reader.mark();
        int nextChar = this.peek();
        if (this.isIdentifierInitialChar(nextChar)) {
            this.reader.advance();
            while (this.isIdentifierFollowingChar(this.peek())) {
                this.reader.advance();
            }
            STToken token = "return".equals(this.getLexeme()) ? this.getDocumentationSyntaxToken(SyntaxKind.RETURN_KEYWORD) : this.getDocumentationLiteral(SyntaxKind.PARAMETER_NAME);
            if (this.peek() != 45) {
                this.switchMode(ParserMode.DOCUMENTATION_INTERNAL);
            }
            return token;
        }
        if (nextChar == 45) {
            this.reader.advance();
            this.switchMode(ParserMode.DOCUMENTATION_INTERNAL);
            return this.getDocumentationSyntaxTokenWithNoTrivia(SyntaxKind.MINUS_TOKEN);
        }
        this.switchMode(ParserMode.DOCUMENTATION_INTERNAL);
        return this.readDocumentationInternalToken();
    }

    private STToken readDocumentationReferenceTypeToken() {
        int nextChar = this.peek();
        if (nextChar == 96) {
            this.reader.advance();
            this.switchMode(ParserMode.DOCUMENTATION_BACKTICK_CONTENT);
            return this.getDocumentationSyntaxToken(SyntaxKind.BACKTICK_TOKEN);
        }
        while (this.isIdentifierInitialChar(this.peek())) {
            this.reader.advance();
        }
        this.setReferenceMode(BacktickReferenceMode.SPECIAL_KEYWORD);
        return this.processReferenceType();
    }

    private STToken processReferenceType() {
        String tokenText;
        switch (tokenText = this.getLexeme()) {
            case "type": {
                return this.getDocumentationSyntaxToken(SyntaxKind.TYPE_DOC_REFERENCE_TOKEN);
            }
            case "service": {
                return this.getDocumentationSyntaxToken(SyntaxKind.SERVICE_DOC_REFERENCE_TOKEN);
            }
            case "variable": {
                return this.getDocumentationSyntaxToken(SyntaxKind.VARIABLE_DOC_REFERENCE_TOKEN);
            }
            case "var": {
                return this.getDocumentationSyntaxToken(SyntaxKind.VAR_DOC_REFERENCE_TOKEN);
            }
            case "annotation": {
                return this.getDocumentationSyntaxToken(SyntaxKind.ANNOTATION_DOC_REFERENCE_TOKEN);
            }
            case "module": {
                return this.getDocumentationSyntaxToken(SyntaxKind.MODULE_DOC_REFERENCE_TOKEN);
            }
            case "function": {
                this.setReferenceMode(BacktickReferenceMode.FUNCTION_KEYWORD);
                return this.getDocumentationSyntaxToken(SyntaxKind.FUNCTION_DOC_REFERENCE_TOKEN);
            }
            case "parameter": {
                return this.getDocumentationSyntaxToken(SyntaxKind.PARAMETER_DOC_REFERENCE_TOKEN);
            }
            case "const": {
                return this.getDocumentationSyntaxToken(SyntaxKind.CONST_DOC_REFERENCE_TOKEN);
            }
        }
        throw new IllegalStateException();
    }

    private STToken readDocumentationBacktickContentToken() {
        this.reader.mark();
        int nextChar = this.peek();
        if (nextChar == 96) {
            this.reader.advance();
            this.switchMode(ParserMode.DOCUMENTATION_INTERNAL);
            this.resetReferenceMode();
            return this.getDocumentationSyntaxTokenWithNoTrivia(SyntaxKind.BACKTICK_TOKEN);
        }
        this.processBacktickContent();
        if (this.hasMatch && this.getLookAheadChar() == 96) {
            this.switchMode(ParserMode.DOCUMENTATION_BACKTICK_EXPR);
            this.resetReferenceMode();
            return this.readDocumentationBacktickExprToken();
        }
        this.reader.advance(this.lookAheadNumber);
        this.processInvalidChars();
        if (this.referenceMode != BacktickReferenceMode.NO_KEYWORD) {
            String invalidIdentifier = this.getLexeme();
            this.reportLexerError(DiagnosticWarningCode.WARNING_INVALID_DOCUMENTATION_IDENTIFIER, invalidIdentifier);
        }
        this.resetReferenceMode();
        return this.getDocumentationLiteral(SyntaxKind.BACKTICK_CONTENT);
    }

    private void processInvalidChars() {
        int nextChar = this.peek();
        block3: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 10: 
                case 13: 
                case 96: {
                    break block3;
                }
                default: {
                    this.reader.advance();
                    nextChar = this.peek();
                    continue block3;
                }
            }
        }
    }

    private void processBacktickContent() {
        this.resetSearchProperties();
        switch (this.referenceMode) {
            case SPECIAL_KEYWORD: {
                this.processQualifiedIdentifier();
                break;
            }
            case FUNCTION_KEYWORD: {
                this.processBacktickExpr(false);
                break;
            }
            case NO_KEYWORD: {
                this.processBacktickExpr(true);
            }
        }
    }

    private void processBacktickExpr(boolean isNotFunctionKeyword) {
        this.processQualifiedIdentifier();
        int nextChar = this.getLookAheadChar();
        if (nextChar == 40) {
            this.processFuncSignature();
        } else if (nextChar == 46) {
            this.consumeChar();
            this.processIdentifier();
            this.processFuncSignature();
        } else if (isNotFunctionKeyword) {
            this.hasMatch = false;
        }
    }

    private void processFuncSignature() {
        this.processOpenParenthesis();
        this.processCloseParenthesis();
    }

    private void processOpenParenthesis() {
        int nextChar = this.getLookAheadChar();
        if (nextChar == 40) {
            this.consumeChar();
        } else {
            this.hasMatch = false;
        }
    }

    private void processCloseParenthesis() {
        int nextChar = this.getLookAheadChar();
        if (nextChar == 41) {
            this.consumeChar();
        } else {
            this.hasMatch = false;
        }
    }

    private void processQualifiedIdentifier() {
        this.processIdentifier();
        int nextChar = this.getLookAheadChar();
        if (nextChar == 58) {
            this.consumeChar();
            this.processIdentifier();
        }
    }

    private void processIdentifier() {
        int nextChar = this.getLookAheadChar();
        if (this.isIdentifierInitialChar(nextChar)) {
            this.consumeChar();
            nextChar = this.getLookAheadChar();
            while (this.isIdentifierFollowingChar(nextChar)) {
                this.consumeChar();
                nextChar = this.getLookAheadChar();
            }
        } else {
            this.hasMatch = false;
        }
    }

    private STToken readDocumentationBacktickExprToken() {
        this.reader.mark();
        int nextChar = this.peek();
        this.reader.advance();
        switch (nextChar) {
            case 96: {
                this.switchMode(ParserMode.DOCUMENTATION_INTERNAL);
                return this.getDocumentationSyntaxTokenWithNoTrivia(SyntaxKind.BACKTICK_TOKEN);
            }
            case 46: {
                return this.getDocumentationSyntaxToken(SyntaxKind.DOT_TOKEN);
            }
            case 58: {
                return this.getDocumentationSyntaxToken(SyntaxKind.COLON_TOKEN);
            }
            case 40: {
                return this.getDocumentationSyntaxToken(SyntaxKind.OPEN_PAREN_TOKEN);
            }
            case 41: {
                return this.getDocumentationSyntaxToken(SyntaxKind.CLOSE_PAREN_TOKEN);
            }
        }
        while (this.isIdentifierFollowingChar(this.peek())) {
            this.reader.advance();
        }
        return this.getIdentifierToken();
    }

    private static enum BacktickReferenceMode {
        NO_KEYWORD,
        SPECIAL_KEYWORD,
        FUNCTION_KEYWORD;

    }
}

