/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.AnnotationAttachPointNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STAnnotationAttachPointNode
extends STNode {
    public final STNode sourceKeyword;
    public final STNode firstIdent;
    public final STNode secondIdent;

    STAnnotationAttachPointNode(STNode sourceKeyword, STNode firstIdent, STNode secondIdent) {
        this(sourceKeyword, firstIdent, secondIdent, Collections.emptyList());
    }

    STAnnotationAttachPointNode(STNode sourceKeyword, STNode firstIdent, STNode secondIdent, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ANNOTATION_ATTACH_POINT, diagnostics);
        this.sourceKeyword = sourceKeyword;
        this.firstIdent = firstIdent;
        this.secondIdent = secondIdent;
        this.addChildren(sourceKeyword, firstIdent, secondIdent);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STAnnotationAttachPointNode(this.sourceKeyword, this.firstIdent, this.secondIdent, diagnostics);
    }

    public STAnnotationAttachPointNode modify(STNode sourceKeyword, STNode firstIdent, STNode secondIdent) {
        if (this.checkForReferenceEquality(sourceKeyword, firstIdent, secondIdent)) {
            return this;
        }
        return new STAnnotationAttachPointNode(sourceKeyword, firstIdent, secondIdent, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new AnnotationAttachPointNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

