/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STModuleMemberDeclarationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STClassDefinitionNode
extends STModuleMemberDeclarationNode {
    public final STNode metadata;
    public final STNode visibilityQualifier;
    public final STNode classTypeQualifiers;
    public final STNode classKeyword;
    public final STNode className;
    public final STNode openBrace;
    public final STNode members;
    public final STNode closeBrace;

    STClassDefinitionNode(STNode metadata, STNode visibilityQualifier, STNode classTypeQualifiers, STNode classKeyword, STNode className, STNode openBrace, STNode members, STNode closeBrace) {
        this(metadata, visibilityQualifier, classTypeQualifiers, classKeyword, className, openBrace, members, closeBrace, Collections.emptyList());
    }

    STClassDefinitionNode(STNode metadata, STNode visibilityQualifier, STNode classTypeQualifiers, STNode classKeyword, STNode className, STNode openBrace, STNode members, STNode closeBrace, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.CLASS_DEFINITION, diagnostics);
        this.metadata = metadata;
        this.visibilityQualifier = visibilityQualifier;
        this.classTypeQualifiers = classTypeQualifiers;
        this.classKeyword = classKeyword;
        this.className = className;
        this.openBrace = openBrace;
        this.members = members;
        this.closeBrace = closeBrace;
        this.addChildren(metadata, visibilityQualifier, classTypeQualifiers, classKeyword, className, openBrace, members, closeBrace);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STClassDefinitionNode(this.metadata, this.visibilityQualifier, this.classTypeQualifiers, this.classKeyword, this.className, this.openBrace, this.members, this.closeBrace, diagnostics);
    }

    public STClassDefinitionNode modify(STNode metadata, STNode visibilityQualifier, STNode classTypeQualifiers, STNode classKeyword, STNode className, STNode openBrace, STNode members, STNode closeBrace) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, classTypeQualifiers, classKeyword, className, openBrace, members, closeBrace)) {
            return this;
        }
        return new STClassDefinitionNode(metadata, visibilityQualifier, classTypeQualifiers, classKeyword, className, openBrace, members, closeBrace, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ClassDefinitionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

