/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ErrorTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STErrorTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode errorKeywordToken;
    public final STNode errorTypeParamsNode;

    STErrorTypeDescriptorNode(STNode errorKeywordToken, STNode errorTypeParamsNode) {
        this(errorKeywordToken, errorTypeParamsNode, Collections.emptyList());
    }

    STErrorTypeDescriptorNode(STNode errorKeywordToken, STNode errorTypeParamsNode, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ERROR_TYPE_DESC, diagnostics);
        this.errorKeywordToken = errorKeywordToken;
        this.errorTypeParamsNode = errorTypeParamsNode;
        this.addChildren(errorKeywordToken, errorTypeParamsNode);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STErrorTypeDescriptorNode(this.errorKeywordToken, this.errorTypeParamsNode, diagnostics);
    }

    public STErrorTypeDescriptorNode modify(STNode errorKeywordToken, STNode errorTypeParamsNode) {
        if (this.checkForReferenceEquality(errorKeywordToken, errorTypeParamsNode)) {
            return this;
        }
        return new STErrorTypeDescriptorNode(errorKeywordToken, errorTypeParamsNode, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ErrorTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

