/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STFieldAccessExpressionNode
extends STExpressionNode {
    public final STNode expression;
    public final STNode dotToken;
    public final STNode fieldName;

    STFieldAccessExpressionNode(STNode expression, STNode dotToken, STNode fieldName) {
        this(expression, dotToken, fieldName, Collections.emptyList());
    }

    STFieldAccessExpressionNode(STNode expression, STNode dotToken, STNode fieldName, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.FIELD_ACCESS, diagnostics);
        this.expression = expression;
        this.dotToken = dotToken;
        this.fieldName = fieldName;
        this.addChildren(expression, dotToken, fieldName);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STFieldAccessExpressionNode(this.expression, this.dotToken, this.fieldName, diagnostics);
    }

    public STFieldAccessExpressionNode modify(STNode expression, STNode dotToken, STNode fieldName) {
        if (this.checkForReferenceEquality(expression, dotToken, fieldName)) {
            return this;
        }
        return new STFieldAccessExpressionNode(expression, dotToken, fieldName, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new FieldAccessExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

