/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STIdentifierToken
extends STToken {
    public final String text;

    STIdentifierToken(String text, STNode leadingTrivia, STNode trailingTrivia) {
        this(text, leadingTrivia, trailingTrivia, Collections.emptyList());
    }

    STIdentifierToken(String text, STNode leadingTrivia, STNode trailingTrivia, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.IDENTIFIER_TOKEN, text.length(), leadingTrivia, trailingTrivia, diagnostics);
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public STToken modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STIdentifierToken(this.text, this.leadingMinutiae, this.trailingMinutiae, diagnostics);
    }

    @Override
    public STToken modifyWith(STNode leadingMinutiae, STNode trailingMinutiae) {
        return new STIdentifierToken(this.text, leadingMinutiae, trailingMinutiae, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new IdentifierToken(this, position, parent);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }

    @Override
    public String toString() {
        return this.leadingMinutiae + this.text + this.trailingMinutiae;
    }

    @Override
    public void writeTo(StringBuilder builder) {
        this.leadingMinutiae.writeTo(builder);
        builder.append(this.text);
        this.trailingMinutiae.writeTo(builder);
    }
}

