/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMatchStatementNode
extends STStatementNode {
    public final STNode matchKeyword;
    public final STNode condition;
    public final STNode openBrace;
    public final STNode matchClauses;
    public final STNode closeBrace;
    public final STNode onFailClause;

    STMatchStatementNode(STNode matchKeyword, STNode condition, STNode openBrace, STNode matchClauses, STNode closeBrace, STNode onFailClause) {
        this(matchKeyword, condition, openBrace, matchClauses, closeBrace, onFailClause, Collections.emptyList());
    }

    STMatchStatementNode(STNode matchKeyword, STNode condition, STNode openBrace, STNode matchClauses, STNode closeBrace, STNode onFailClause, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MATCH_STATEMENT, diagnostics);
        this.matchKeyword = matchKeyword;
        this.condition = condition;
        this.openBrace = openBrace;
        this.matchClauses = matchClauses;
        this.closeBrace = closeBrace;
        this.onFailClause = onFailClause;
        this.addChildren(matchKeyword, condition, openBrace, matchClauses, closeBrace, onFailClause);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMatchStatementNode(this.matchKeyword, this.condition, this.openBrace, this.matchClauses, this.closeBrace, this.onFailClause, diagnostics);
    }

    public STMatchStatementNode modify(STNode matchKeyword, STNode condition, STNode openBrace, STNode matchClauses, STNode closeBrace, STNode onFailClause) {
        if (this.checkForReferenceEquality(matchKeyword, condition, openBrace, matchClauses, closeBrace, onFailClause)) {
            return this;
        }
        return new STMatchStatementNode(matchKeyword, condition, openBrace, matchClauses, closeBrace, onFailClause, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MatchStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

