/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMetadataNode
extends STNode {
    public final STNode documentationString;
    public final STNode annotations;

    STMetadataNode(STNode documentationString, STNode annotations) {
        this(documentationString, annotations, Collections.emptyList());
    }

    STMetadataNode(STNode documentationString, STNode annotations, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.METADATA, diagnostics);
        this.documentationString = documentationString;
        this.annotations = annotations;
        this.addChildren(documentationString, annotations);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMetadataNode(this.documentationString, this.annotations, diagnostics);
    }

    public STMetadataNode modify(STNode documentationString, STNode annotations) {
        if (this.checkForReferenceEquality(documentationString, annotations)) {
            return this;
        }
        return new STMetadataNode(documentationString, annotations, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MetadataNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

