/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STObjectFieldNode
extends STNode {
    public final STNode metadata;
    public final STNode visibilityQualifier;
    public final STNode finalKeyword;
    public final STNode typeName;
    public final STNode fieldName;
    public final STNode equalsToken;
    public final STNode expression;
    public final STNode semicolonToken;

    STObjectFieldNode(STNode metadata, STNode visibilityQualifier, STNode finalKeyword, STNode typeName, STNode fieldName, STNode equalsToken, STNode expression, STNode semicolonToken) {
        this(metadata, visibilityQualifier, finalKeyword, typeName, fieldName, equalsToken, expression, semicolonToken, Collections.emptyList());
    }

    STObjectFieldNode(STNode metadata, STNode visibilityQualifier, STNode finalKeyword, STNode typeName, STNode fieldName, STNode equalsToken, STNode expression, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.OBJECT_FIELD, diagnostics);
        this.metadata = metadata;
        this.visibilityQualifier = visibilityQualifier;
        this.finalKeyword = finalKeyword;
        this.typeName = typeName;
        this.fieldName = fieldName;
        this.equalsToken = equalsToken;
        this.expression = expression;
        this.semicolonToken = semicolonToken;
        this.addChildren(metadata, visibilityQualifier, finalKeyword, typeName, fieldName, equalsToken, expression, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STObjectFieldNode(this.metadata, this.visibilityQualifier, this.finalKeyword, this.typeName, this.fieldName, this.equalsToken, this.expression, this.semicolonToken, diagnostics);
    }

    public STObjectFieldNode modify(STNode metadata, STNode visibilityQualifier, STNode finalKeyword, STNode typeName, STNode fieldName, STNode equalsToken, STNode expression, STNode semicolonToken) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, finalKeyword, typeName, fieldName, equalsToken, expression, semicolonToken)) {
            return this;
        }
        return new STObjectFieldNode(metadata, visibilityQualifier, finalKeyword, typeName, fieldName, equalsToken, expression, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ObjectFieldNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

