/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STQueryExpressionNode
extends STExpressionNode {
    public final STNode queryConstructType;
    public final STNode queryPipeline;
    public final STNode selectClause;
    public final STNode onConflictClause;

    STQueryExpressionNode(STNode queryConstructType, STNode queryPipeline, STNode selectClause, STNode onConflictClause) {
        this(queryConstructType, queryPipeline, selectClause, onConflictClause, Collections.emptyList());
    }

    STQueryExpressionNode(STNode queryConstructType, STNode queryPipeline, STNode selectClause, STNode onConflictClause, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.QUERY_EXPRESSION, diagnostics);
        this.queryConstructType = queryConstructType;
        this.queryPipeline = queryPipeline;
        this.selectClause = selectClause;
        this.onConflictClause = onConflictClause;
        this.addChildren(queryConstructType, queryPipeline, selectClause, onConflictClause);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STQueryExpressionNode(this.queryConstructType, this.queryPipeline, this.selectClause, this.onConflictClause, diagnostics);
    }

    public STQueryExpressionNode modify(STNode queryConstructType, STNode queryPipeline, STNode selectClause, STNode onConflictClause) {
        if (this.checkForReferenceEquality(queryConstructType, queryPipeline, selectClause, onConflictClause)) {
            return this;
        }
        return new STQueryExpressionNode(queryConstructType, queryPipeline, selectClause, onConflictClause, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new QueryExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

