/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STServiceConstructorExpressionNode
extends STExpressionNode {
    public final STNode annotations;
    public final STNode serviceKeyword;
    public final STNode serviceBody;

    STServiceConstructorExpressionNode(STNode annotations, STNode serviceKeyword, STNode serviceBody) {
        this(annotations, serviceKeyword, serviceBody, Collections.emptyList());
    }

    STServiceConstructorExpressionNode(STNode annotations, STNode serviceKeyword, STNode serviceBody, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.SERVICE_CONSTRUCTOR_EXPRESSION, diagnostics);
        this.annotations = annotations;
        this.serviceKeyword = serviceKeyword;
        this.serviceBody = serviceBody;
        this.addChildren(annotations, serviceKeyword, serviceBody);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STServiceConstructorExpressionNode(this.annotations, this.serviceKeyword, this.serviceBody, diagnostics);
    }

    public STServiceConstructorExpressionNode modify(STNode annotations, STNode serviceKeyword, STNode serviceBody) {
        if (this.checkForReferenceEquality(annotations, serviceKeyword, serviceBody)) {
            return this;
        }
        return new STServiceConstructorExpressionNode(annotations, serviceKeyword, serviceBody, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ServiceConstructorExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

