/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STModuleMemberDeclarationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STServiceDeclarationNode
extends STModuleMemberDeclarationNode {
    public final STNode metadata;
    public final STNode qualifiers;
    public final STNode serviceKeyword;
    public final STNode serviceName;
    public final STNode onKeyword;
    public final STNode expressions;
    public final STNode serviceBody;

    STServiceDeclarationNode(STNode metadata, STNode qualifiers, STNode serviceKeyword, STNode serviceName, STNode onKeyword, STNode expressions, STNode serviceBody) {
        this(metadata, qualifiers, serviceKeyword, serviceName, onKeyword, expressions, serviceBody, Collections.emptyList());
    }

    STServiceDeclarationNode(STNode metadata, STNode qualifiers, STNode serviceKeyword, STNode serviceName, STNode onKeyword, STNode expressions, STNode serviceBody, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.SERVICE_DECLARATION, diagnostics);
        this.metadata = metadata;
        this.qualifiers = qualifiers;
        this.serviceKeyword = serviceKeyword;
        this.serviceName = serviceName;
        this.onKeyword = onKeyword;
        this.expressions = expressions;
        this.serviceBody = serviceBody;
        this.addChildren(metadata, qualifiers, serviceKeyword, serviceName, onKeyword, expressions, serviceBody);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STServiceDeclarationNode(this.metadata, this.qualifiers, this.serviceKeyword, this.serviceName, this.onKeyword, this.expressions, this.serviceBody, diagnostics);
    }

    public STServiceDeclarationNode modify(STNode metadata, STNode qualifiers, STNode serviceKeyword, STNode serviceName, STNode onKeyword, STNode expressions, STNode serviceBody) {
        if (this.checkForReferenceEquality(metadata, qualifiers, serviceKeyword, serviceName, onKeyword, expressions, serviceBody)) {
            return this;
        }
        return new STServiceDeclarationNode(metadata, qualifiers, serviceKeyword, serviceName, onKeyword, expressions, serviceBody, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ServiceDeclarationNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

