/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeofExpressionNode;
import java.util.Collection;
import java.util.Collections;

public class STTypeofExpressionNode
extends STExpressionNode {
    public final STNode typeofKeyword;
    public final STNode expression;

    STTypeofExpressionNode(STNode typeofKeyword, STNode expression) {
        this(typeofKeyword, expression, Collections.emptyList());
    }

    STTypeofExpressionNode(STNode typeofKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TYPEOF_EXPRESSION, diagnostics);
        this.typeofKeyword = typeofKeyword;
        this.expression = expression;
        this.addChildren(typeofKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTypeofExpressionNode(this.typeofKeyword, this.expression, diagnostics);
    }

    public STTypeofExpressionNode modify(STNode typeofKeyword, STNode expression) {
        if (this.checkForReferenceEquality(typeofKeyword, expression)) {
            return this;
        }
        return new STTypeofExpressionNode(typeofKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TypeofExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

