/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import java.util.Collection;
import java.util.Collections;

public class STWhileStatementNode
extends STStatementNode {
    public final STNode whileKeyword;
    public final STNode condition;
    public final STNode whileBody;
    public final STNode onFailClause;

    STWhileStatementNode(STNode whileKeyword, STNode condition, STNode whileBody, STNode onFailClause) {
        this(whileKeyword, condition, whileBody, onFailClause, Collections.emptyList());
    }

    STWhileStatementNode(STNode whileKeyword, STNode condition, STNode whileBody, STNode onFailClause, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.WHILE_STATEMENT, diagnostics);
        this.whileKeyword = whileKeyword;
        this.condition = condition;
        this.whileBody = whileBody;
        this.onFailClause = onFailClause;
        this.addChildren(whileKeyword, condition, whileBody, onFailClause);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STWhileStatementNode(this.whileKeyword, this.condition, this.whileBody, this.onFailClause, diagnostics);
    }

    public STWhileStatementNode modify(STNode whileKeyword, STNode condition, STNode whileBody, STNode onFailClause) {
        if (this.checkForReferenceEquality(whileKeyword, condition, whileBody, onFailClause)) {
            return this;
        }
        return new STWhileStatementNode(whileKeyword, condition, whileBody, onFailClause, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new WhileStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

