/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XmlTypeDescriptorNode;
import java.util.Collection;
import java.util.Collections;

public class STXmlTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode xmlKeywordToken;
    public final STNode xmlTypeParamsNode;

    STXmlTypeDescriptorNode(STNode xmlKeywordToken, STNode xmlTypeParamsNode) {
        this(xmlKeywordToken, xmlTypeParamsNode, Collections.emptyList());
    }

    STXmlTypeDescriptorNode(STNode xmlKeywordToken, STNode xmlTypeParamsNode, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_TYPE_DESC, diagnostics);
        this.xmlKeywordToken = xmlKeywordToken;
        this.xmlTypeParamsNode = xmlTypeParamsNode;
        this.addChildren(xmlKeywordToken, xmlTypeParamsNode);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXmlTypeDescriptorNode(this.xmlKeywordToken, this.xmlTypeParamsNode, diagnostics);
    }

    public STXmlTypeDescriptorNode modify(STNode xmlKeywordToken, STNode xmlTypeParamsNode) {
        if (this.checkForReferenceEquality(xmlKeywordToken, xmlTypeParamsNode)) {
            return this;
        }
        return new STXmlTypeDescriptorNode(xmlKeywordToken, xmlTypeParamsNode, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XmlTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

