/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class ArrayTypeDescriptorNode
extends TypeDescriptorNode {
    public ArrayTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public TypeDescriptorNode memberTypeDesc() {
        return (TypeDescriptorNode)this.childInBucket(0);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(1);
    }

    public Optional<Node> arrayLength() {
        return this.optionalChildInBucket(2);
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"memberTypeDesc", "openBracket", "arrayLength", "closeBracket"};
    }

    public ArrayTypeDescriptorNode modify(TypeDescriptorNode memberTypeDesc, Token openBracket, Node arrayLength, Token closeBracket) {
        if (this.checkForReferenceEquality(memberTypeDesc, openBracket, arrayLength, closeBracket)) {
            return this;
        }
        return NodeFactory.createArrayTypeDescriptorNode(memberTypeDesc, openBracket, arrayLength, closeBracket);
    }

    public ArrayTypeDescriptorNodeModifier modify() {
        return new ArrayTypeDescriptorNodeModifier(this);
    }

    public static class ArrayTypeDescriptorNodeModifier {
        private final ArrayTypeDescriptorNode oldNode;
        private TypeDescriptorNode memberTypeDesc;
        private Token openBracket;
        private Node arrayLength;
        private Token closeBracket;

        public ArrayTypeDescriptorNodeModifier(ArrayTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.memberTypeDesc = oldNode.memberTypeDesc();
            this.openBracket = oldNode.openBracket();
            this.arrayLength = oldNode.arrayLength().orElse(null);
            this.closeBracket = oldNode.closeBracket();
        }

        public ArrayTypeDescriptorNodeModifier withMemberTypeDesc(TypeDescriptorNode memberTypeDesc) {
            Objects.requireNonNull(memberTypeDesc, "memberTypeDesc must not be null");
            this.memberTypeDesc = memberTypeDesc;
            return this;
        }

        public ArrayTypeDescriptorNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public ArrayTypeDescriptorNodeModifier withArrayLength(Node arrayLength) {
            this.arrayLength = arrayLength;
            return this;
        }

        public ArrayTypeDescriptorNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public ArrayTypeDescriptorNode apply() {
            return this.oldNode.modify(this.memberTypeDesc, this.openBracket, this.arrayLength, this.closeBracket);
        }
    }
}

