/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class BlockStatementNode
extends StatementNode {
    public BlockStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<StatementNode> statements() {
        return new NodeList<StatementNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBraceToken", "statements", "closeBraceToken"};
    }

    public BlockStatementNode modify(Token openBraceToken, NodeList<StatementNode> statements, Token closeBraceToken) {
        if (this.checkForReferenceEquality(openBraceToken, statements.underlyingListNode(), closeBraceToken)) {
            return this;
        }
        return NodeFactory.createBlockStatementNode(openBraceToken, statements, closeBraceToken);
    }

    public BlockStatementNodeModifier modify() {
        return new BlockStatementNodeModifier(this);
    }

    public static class BlockStatementNodeModifier {
        private final BlockStatementNode oldNode;
        private Token openBraceToken;
        private NodeList<StatementNode> statements;
        private Token closeBraceToken;

        public BlockStatementNodeModifier(BlockStatementNode oldNode) {
            this.oldNode = oldNode;
            this.openBraceToken = oldNode.openBraceToken();
            this.statements = oldNode.statements();
            this.closeBraceToken = oldNode.closeBraceToken();
        }

        public BlockStatementNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public BlockStatementNodeModifier withStatements(NodeList<StatementNode> statements) {
            Objects.requireNonNull(statements, "statements must not be null");
            this.statements = statements;
            return this;
        }

        public BlockStatementNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public BlockStatementNode apply() {
            return this.oldNode.modify(this.openBraceToken, this.statements, this.closeBraceToken);
        }
    }
}

