/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class DefaultableParameterNode
extends ParameterNode {
    public DefaultableParameterNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Node typeName() {
        return this.childInBucket(1);
    }

    public Optional<Token> paramName() {
        return this.optionalChildInBucket(2);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(3);
    }

    public Node expression() {
        return this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "typeName", "paramName", "equalsToken", "expression"};
    }

    public DefaultableParameterNode modify(NodeList<AnnotationNode> annotations, Node typeName, Token paramName, Token equalsToken, Node expression) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), typeName, paramName, equalsToken, expression)) {
            return this;
        }
        return NodeFactory.createDefaultableParameterNode(annotations, typeName, paramName, equalsToken, expression);
    }

    public DefaultableParameterNodeModifier modify() {
        return new DefaultableParameterNodeModifier(this);
    }

    public static class DefaultableParameterNodeModifier {
        private final DefaultableParameterNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Node typeName;
        private Token paramName;
        private Token equalsToken;
        private Node expression;

        public DefaultableParameterNodeModifier(DefaultableParameterNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.typeName = oldNode.typeName();
            this.paramName = oldNode.paramName().orElse(null);
            this.equalsToken = oldNode.equalsToken();
            this.expression = oldNode.expression();
        }

        public DefaultableParameterNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public DefaultableParameterNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public DefaultableParameterNodeModifier withParamName(Token paramName) {
            this.paramName = paramName;
            return this;
        }

        public DefaultableParameterNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public DefaultableParameterNodeModifier withExpression(Node expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public DefaultableParameterNode apply() {
            return this.oldNode.modify(this.annotations, this.typeName, this.paramName, this.equalsToken, this.expression);
        }
    }
}

