/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.DocumentationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class DocumentationReferenceNode
extends DocumentationNode {
    public DocumentationReferenceNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Token> referenceType() {
        return this.optionalChildInBucket(0);
    }

    public Token startBacktick() {
        return (Token)this.childInBucket(1);
    }

    public Node backtickContent() {
        return this.childInBucket(2);
    }

    public Token endBacktick() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"referenceType", "startBacktick", "backtickContent", "endBacktick"};
    }

    public DocumentationReferenceNode modify(Token referenceType, Token startBacktick, Node backtickContent, Token endBacktick) {
        if (this.checkForReferenceEquality(referenceType, startBacktick, backtickContent, endBacktick)) {
            return this;
        }
        return NodeFactory.createDocumentationReferenceNode(referenceType, startBacktick, backtickContent, endBacktick);
    }

    public DocumentationReferenceNodeModifier modify() {
        return new DocumentationReferenceNodeModifier(this);
    }

    public static class DocumentationReferenceNodeModifier {
        private final DocumentationReferenceNode oldNode;
        private Token referenceType;
        private Token startBacktick;
        private Node backtickContent;
        private Token endBacktick;

        public DocumentationReferenceNodeModifier(DocumentationReferenceNode oldNode) {
            this.oldNode = oldNode;
            this.referenceType = oldNode.referenceType().orElse(null);
            this.startBacktick = oldNode.startBacktick();
            this.backtickContent = oldNode.backtickContent();
            this.endBacktick = oldNode.endBacktick();
        }

        public DocumentationReferenceNodeModifier withReferenceType(Token referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public DocumentationReferenceNodeModifier withStartBacktick(Token startBacktick) {
            Objects.requireNonNull(startBacktick, "startBacktick must not be null");
            this.startBacktick = startBacktick;
            return this;
        }

        public DocumentationReferenceNodeModifier withBacktickContent(Node backtickContent) {
            Objects.requireNonNull(backtickContent, "backtickContent must not be null");
            this.backtickContent = backtickContent;
            return this;
        }

        public DocumentationReferenceNodeModifier withEndBacktick(Token endBacktick) {
            Objects.requireNonNull(endBacktick, "endBacktick must not be null");
            this.endBacktick = endBacktick;
            return this;
        }

        public DocumentationReferenceNode apply() {
            return this.oldNode.modify(this.referenceType, this.startBacktick, this.backtickContent, this.endBacktick);
        }
    }
}

