/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class FunctionCallExpressionNode
extends ExpressionNode {
    public FunctionCallExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NameReferenceNode functionName() {
        return (NameReferenceNode)this.childInBucket(0);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(1);
    }

    public SeparatedNodeList<FunctionArgumentNode> arguments() {
        return new SeparatedNodeList<FunctionArgumentNode>((NonTerminalNode)this.childInBucket(2));
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"functionName", "openParenToken", "arguments", "closeParenToken"};
    }

    public FunctionCallExpressionNode modify(NameReferenceNode functionName, Token openParenToken, SeparatedNodeList<FunctionArgumentNode> arguments, Token closeParenToken) {
        if (this.checkForReferenceEquality(functionName, openParenToken, arguments.underlyingListNode(), closeParenToken)) {
            return this;
        }
        return NodeFactory.createFunctionCallExpressionNode(functionName, openParenToken, arguments, closeParenToken);
    }

    public FunctionCallExpressionNodeModifier modify() {
        return new FunctionCallExpressionNodeModifier(this);
    }

    public static class FunctionCallExpressionNodeModifier {
        private final FunctionCallExpressionNode oldNode;
        private NameReferenceNode functionName;
        private Token openParenToken;
        private SeparatedNodeList<FunctionArgumentNode> arguments;
        private Token closeParenToken;

        public FunctionCallExpressionNodeModifier(FunctionCallExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.functionName = oldNode.functionName();
            this.openParenToken = oldNode.openParenToken();
            this.arguments = oldNode.arguments();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public FunctionCallExpressionNodeModifier withFunctionName(NameReferenceNode functionName) {
            Objects.requireNonNull(functionName, "functionName must not be null");
            this.functionName = functionName;
            return this;
        }

        public FunctionCallExpressionNodeModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public FunctionCallExpressionNodeModifier withArguments(SeparatedNodeList<FunctionArgumentNode> arguments) {
            Objects.requireNonNull(arguments, "arguments must not be null");
            this.arguments = arguments;
            return this;
        }

        public FunctionCallExpressionNodeModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public FunctionCallExpressionNode apply() {
            return this.oldNode.modify(this.functionName, this.openParenToken, this.arguments, this.closeParenToken);
        }
    }
}

